/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.clustering.hierarchical.AtrGtrDendrogram;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.actions.AnnotateAction;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeOptionsPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.io.excel.AddToMetadataContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.matrix.gct.GctReader;
import org.broadinstitute.genee.io.matrix.gctx.GctxProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.math.stat.function.Median;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DefaultClassVector;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class OpenFile {
    private Application.ApplicationArgs args;

    public OpenFile(Application.ApplicationArgs args) {
        this.args = args;
    }

    public boolean containsData() {
        return this.args.getData() != null;
    }

    private static String decodeUrl(String s) throws IOException {
        URL url = new URL(s);
        String query = url.getQuery();
        if (query == null) {
            return s;
        }
        String[] tokens = query.split("&");
        StringBuilder q = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String[] pair = tokens[i].split("=");
            if (i > 0) {
                q.append("&");
            }
            q.append(URLEncoder.encode(pair[0], "UTF-8"));
            q.append("=");
            q.append(URLEncoder.encode(pair[1], "UTF-8"));
        }
        return url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + url.getPath() + "?" + q;
    }

    private static Map<String, List<String>> getUrlParams(String s) {
        HashMap<String, List<String>> nameToValue = new HashMap<String, List<String>>();
        try {
            URL url = new URL(s);
            String[] tokens = url.getQuery().split("&");
            for (int i = 0; i < tokens.length; ++i) {
                String[] pair = tokens[i].split("=");
                ArrayList<String> list = (ArrayList<String>)nameToValue.get(pair[0]);
                if (list == null) {
                    list = new ArrayList<String>();
                    nameToValue.put(pair[0], list);
                }
                list.add(pair[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nameToValue;
    }

    public void open() {
        final String filename = IOUtil.getName(this.args.getData());
        new BackgroundTask<GENEEFolderNode>("Loading " + filename){

            @Override
            protected GENEEFolderNode doInBackground() throws Exception {
                if (OpenFile.this.args.getData() == null) {
                    return null;
                }
                History history = new History("Opened " + filename);
                String urlString = OpenFile.this.args.getData();
                try {
                    urlString = OpenFile.decodeUrl(OpenFile.this.args.getData());
                }
                catch (Exception x) {
                    // empty catch block
                }
                Project p = OpenFile.createProject(urlString, OpenFile.this.args);
                ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(p, history);
                try {
                    List color;
                    Map nameToValue = OpenFile.getUrlParams(urlString);
                    if (OpenFile.this.args.getUnparsed() != null) {
                        for (String name : OpenFile.this.args.getUnparsed().keySet()) {
                            ArrayList list = (ArrayList)nameToValue.get(name);
                            if (list == null) {
                                list = new ArrayList();
                                nameToValue.put(name, list);
                            }
                            list.addAll(OpenFile.this.args.getUnparsed().get(name));
                        }
                    }
                    if ((color = (List)nameToValue.get("color")) != null && color.size() == 1) {
                        HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(((HeatMapPanel)node.getDisplayInfo().getComponent()).getColorScheme(), (String)color.get(0));
                    }
                    List up = (List)nameToValue.get("up");
                    List dn = (List)nameToValue.get("dn");
                    if (up != null || dn != null) {
                        Integer index;
                        Vector sig = MetadataUtil.addRowVector(p.getOriginalDataset().getRowMetadata(), "Signature", String.class);
                        Map idToIndex = VectorUtil.createValueToIndexMap(p.getOriginalDataset().getRowMetadata().get("id"));
                        if (up != null) {
                            for (String id : up) {
                                index = idToIndex.get(id);
                                if (index == null) continue;
                                sig.setValue(index, "up");
                            }
                        }
                        if (up != null) {
                            for (String id : dn) {
                                index = idToIndex.get(id);
                                if (index == null) continue;
                                sig.setValue(index, "dn");
                            }
                        }
                        Vector median = MetadataUtil.addRowVector(p.getOriginalDataset().getRowMetadata(), "Median", Float.class);
                        Median medianFunction = new Median();
                        DatasetRowView view = new DatasetRowView(p.getOriginalDataset());
                        int nrows = p.getOriginalDataset().getRowCount();
                        for (int i = 0; i < nrows; ++i) {
                            view.setIndex(i);
                            median.setValue(i, Float.valueOf(medianFunction.evaluate(view)));
                        }
                        p.setRowSortOrder(Arrays.asList(new SortKeys.VectorSortKey(sig.getName(), SortOrder.DESCENDING, true), new SortKeys.VectorSortKey(median.getName(), SortOrder.DESCENDING, true)));
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return new GENEEFolderNode("Open File", history, node);
            }

            @Override
            protected void succeeded(GENEEFolderNode node) {
                if (node != null) {
                    Application.add(node);
                }
            }
        }.execute();
    }

    private static Project createProject(String encodedData, Application.ApplicationArgs args) throws Exception {
        List<String> formatList = args.getUnparsed().get("_fmt");
        ProjectReader reader = null;
        if (formatList != null && formatList.size() == 1) {
            String format = formatList.get(0);
            if ("gct".equals(format)) {
                reader = new GctReader();
            } else if ("gctx".equals(format)) {
                reader = new GctxProjectReader();
            }
        } else {
            reader = ProjectIO.getProjectReader(encodedData);
        }
        if (reader == null) {
            reader = new GctReader();
        }
        Project p = reader.read(encodedData);
        Dataset dataset = p.getOriginalDataset();
        if (args.getColumnColorBarColumns() != null) {
            if (args.getColumnColorBarColumns().toLowerCase().endsWith(".cls")) {
                DefaultClassVector classVector = IOUtil.readCls(args.getColumnColorBarColumns());
                AnnotateAction.loadClassVector(dataset.getColumnMetadata(), classVector);
            } else {
                new ExcelReader(args.getColumnColorBarColumns(), new AddToMetadataContentHandler(dataset.getColumnMetadata(), p.getColumnColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getColumnMetadata().get(0)), false));
            }
        }
        if (args.getRowColorBarColumns() != null) {
            new ExcelReader(args.getRowColorBarColumns(), new AddToMetadataContentHandler(dataset.getRowMetadata(), p.getRowColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getRowMetadata().get(0)), true));
        }
        if (args.getRowTextColumns() != null) {
            new ExcelReader(args.getRowTextColumns(), new AddToMetadataContentHandler(dataset.getRowMetadata(), p.getRowColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getRowMetadata().get(0)), true));
        }
        if (args.getColumnTextColumns() != null) {
            new ExcelReader(args.getColumnTextColumns(), new AddToMetadataContentHandler(dataset.getColumnMetadata(), p.getColumnColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getColumnMetadata().get(0)), false));
        }
        if (args.getAtr() != null) {
            String[] arrayIds = new String[dataset.getColumnCount()];
            int columns = dataset.getColumnCount();
            for (int j = 0; j < columns; ++j) {
                arrayIds[j] = (String)dataset.getColumnMetadata().getValue(j, "array id");
            }
            p.setColumnDendrogram(new AtrGtrDendrogram(arrayIds, args.getAtr()));
        }
        if (args.getGtr() != null) {
            String[] geneIds = new String[dataset.getRowCount()];
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                geneIds[i] = (String)dataset.getRowMetadata().getValue(i, "gene id");
            }
            p.setRowDendrogram(new AtrGtrDendrogram(geneIds, args.getGtr()));
        }
        return p;
    }
}

