/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.util.Collection;
import javax.swing.ListSelectionModel;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.AbstractIndexedQuickSearch;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;

public abstract class QuickListFilter
extends AbstractIndexedQuickSearch {
    private FilterableListModel filterableListModel;
    private ListSelectionModel selectionModel;
    private int[] modelSelection;

    public QuickListFilter(ListSelectionModel list, FilterableListModel listModel) {
        this(list, listModel, false);
    }

    public QuickListFilter(ListSelectionModel list, FilterableListModel listModel, boolean searchResultsRightOfTextField) {
        super(searchResultsRightOfTextField);
        this.filterableListModel = listModel;
        this.selectionModel = list;
    }

    @Override
    protected LuceneSearchParser.SearchPredicateAdapterCreator createSearchPredicateAdapterCreator() {
        return new LuceneSearchParser.SearchPredicateAdapterCreator(){

            @Override
            public LuceneSearchParser.IndexedSearchPredicate create(LuceneSearchParser.InternalSearchPredicate internalSearchPredicate) {
                return new LuceneSearchParser.ListModelSearchPredicateAdapter(internalSearchPredicate);
            }
        };
    }

    @Override
    protected void notifyFilterChanged() {
        int i;
        int length;
        int[] viewSelection = UIUtil.getSelectedIndices(this.selectionModel);
        if (viewSelection.length > 0) {
            this.modelSelection = new int[viewSelection.length];
            length = viewSelection.length;
            for (i = 0; i < length; ++i) {
                this.modelSelection[i] = this.filterableListModel.getActualIndexAt(viewSelection[i]);
            }
        }
        this.filterableListModel.setFilter(this.searchPredicate);
        if (this.searchPredicate != null) {
            this.setLabelText(this.filterableListModel.getSize(), this.filterableListModel.getActualModel().getSize());
        } else {
            this.clearLabelText();
        }
        this.selectionModel.setValueIsAdjusting(true);
        this.selectionModel.clearSelection();
        if (this.modelSelection != null) {
            length = this.modelSelection.length;
            for (i = 0; i < length; ++i) {
                int viewIndex = this.filterableListModel.getIndexAt(this.modelSelection[i]);
                this.selectionModel.addSelectionInterval(viewIndex, viewIndex);
            }
        }
        this.selectionModel.setValueIsAdjusting(false);
    }

    @Override
    protected Collection<String> getAvailableFieldNames() {
        return null;
    }
}

