/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.list.array.TIntArrayList;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.AbstractSelectionModel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;

public class RowSelectionModel
extends AbstractSelectionModel {
    RowSelectionModel(Project project) {
        super(project);
    }

    @Override
    protected void updateViewFromModel(int[] selectedModelIndices) {
        this.updateModelFromView = false;
        this.viewSelectionModel.removeListSelectionListener(this.viewListSelectionListener);
        this.viewSelectionModel.setValueIsAdjusting(true);
        this.viewSelectionModel.clearSelection();
        int length = selectedModelIndices.length;
        for (int i = 0; i < length; ++i) {
            int viewIndex = this.project.convertModelRowIndexToView(selectedModelIndices[i]);
            if (viewIndex == -1) continue;
            this.viewSelectionModel.addSelectionInterval(viewIndex, viewIndex);
        }
        this.viewSelectionModel.setValueIsAdjusting(false);
        this.viewSelectionModel.addListSelectionListener(this.viewListSelectionListener);
    }

    @Override
    protected void updateModelFromView() {
        if (this.viewSelectionModel.isSelectionEmpty()) {
            this.selectedIndices = new int[0];
        } else {
            TIntArrayList tmp = new TIntArrayList();
            int rows = this.project.getSortedFilteredDataset().getRowCount();
            for (int i = 0; i < rows; ++i) {
                int modelIndex;
                if (!this.viewSelectionModel.isSelectedIndex(i) || (modelIndex = this.project.convertViewRowIndexToModel(i)) == -1) continue;
                tmp.add(modelIndex);
            }
            this.selectedIndices = tmp.toArray();
        }
        this.updateModelFromView = false;
    }

    @Override
    public int[] getSelectedViewIndices() {
        Dataset d = this.project.getSortedFilteredDataset();
        if (d == null) {
            return new int[0];
        }
        int[] selection = UIUtil.getSelection(this.viewSelectionModel, 0, d.getRowCount() - 1);
        if (selection == null) {
            selection = new int[]{};
        }
        return selection;
    }
}

