/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.list.array.TIntArrayList;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.Dataset;

public class SelectMissingAction
extends AbstractAction {
    private HeatMapPanel heatMapPanel;
    private boolean row;

    public SelectMissingAction(HeatMapPanel heatMapPanel, boolean row) {
        super("Select " + (row ? "Rows" : "Columns") + " With Missing Values");
        this.heatMapPanel = heatMapPanel;
        this.row = row;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        Dataset dataset = this.heatMapPanel.getProject().getOriginalDataset();
        TIntArrayList indices = new TIntArrayList();
        if (this.row) {
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                int cols = dataset.getColumnCount();
                for (int j = 0; j < cols; ++j) {
                    float d = dataset.getValue(i, j);
                    if (!Float.isNaN(d)) continue;
                    indices.add(i);
                }
            }
            this.heatMapPanel.getProject().setSelectedModelRowIndices(indices.toArray());
        } else {
            int cols = dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                int rows = dataset.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    float d = dataset.getValue(i, j);
                    if (!Float.isNaN(d)) continue;
                    indices.add(j);
                }
            }
            this.heatMapPanel.getProject().setSelectedModelColumnIndices(indices.toArray());
        }
    }
}

