/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.DrawableTransferable;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.UIUtil;

public class CopyImageAction
extends AbstractAction {
    private WeakReference<JComponent> componentWeakRef;
    private WeakReference<Drawable> drawableWeakRef;

    public CopyImageAction() {
        super("Copy Image");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtil.getMenuShortcutKeyMask()));
        this.setEnabled(false);
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/17234.copyviewtoclipboard_tsk.png"));
        this.putValue("ShortDescription", "Copy Image");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent component;
        Drawable d = null;
        Drawable drawable = this.drawableWeakRef != null ? (Drawable)this.drawableWeakRef.get() : null;
        JComponent jComponent = component = this.componentWeakRef != null ? (JComponent)this.componentWeakRef.get() : null;
        if (drawable != null) {
            d = drawable;
        } else if (component != null) {
            Drawable drawable2 = d = component instanceof Drawable ? (Drawable)((Object)component) : new DrawableWrapper(component);
        }
        if (d != null) {
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            c.setContents(new DrawableTransferable(d), null);
        } else {
            System.err.println("No image on clipboard.");
        }
    }

    public void setDrawable(Drawable drawable) {
        WeakReference<Drawable> weakReference = this.drawableWeakRef = drawable != null ? new WeakReference<Drawable>(drawable) : null;
        if (drawable instanceof JComponent) {
            this.setJComponent((JComponent)((Object)drawable));
        }
    }

    public void setJComponent(JComponent component) {
        WeakReference<JComponent> weakReference = this.componentWeakRef = component != null ? new WeakReference<JComponent>(component) : null;
        if (component != null && !GraphicsEnvironment.isHeadless()) {
            KeyStroke ks = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            component.getInputMap(2).put(ks, this.getValue("Name"));
            component.getActionMap().put(this.getValue("Name"), this);
        }
        this.setEnabled(component != null);
    }
}

