/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.filter.AbstractFloatFilter;
import org.broadinstitute.genee.filter.GT;
import org.broadinstitute.genee.filter.GTE;
import org.broadinstitute.genee.filter.LT;
import org.broadinstitute.genee.filter.LTE;
import org.broadinstitute.genee.heatmap.menu.NodeColorScheme;

public class DefaultNodeColorScheme
implements NodeColorScheme {
    protected static final int GREATER_THAN = 0;
    protected static final int GREATER_THAN_OR_EQUAL = 2;
    protected static final int LESS_THAN = 1;
    protected static final int LESS_THAN_OR_EQUAL = 3;
    private Color color = Color.BLUE;
    private AbstractFloatFilter filter = new LTE();
    private Map<String, Float> nodeIdToScore = new HashMap<String, Float>();
    private float significance = 0.05f;

    public DefaultNodeColorScheme() {
        this.filter.setValue(this.significance);
    }

    @Override
    public Color getColor(String nodeId) {
        Float nodeScore = this.nodeIdToScore.get(nodeId);
        if (nodeScore != null && !Float.isNaN(nodeScore.floatValue()) && this.filter.apply(nodeScore.floatValue())) {
            return this.color;
        }
        return Color.BLACK;
    }

    @Override
    public Float getValue(String nodeId) {
        return this.nodeIdToScore.get(nodeId);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setComparison(int comparison) {
        if (comparison == 0) {
            this.filter = new GT();
        } else if (comparison == 1) {
            this.filter = new LT();
        } else if (comparison == 2) {
            this.filter = new GTE();
        } else if (comparison == 3) {
            this.filter = new LTE();
        } else {
            throw new IllegalArgumentException();
        }
        this.filter.setValue(this.significance);
    }

    public void setScore(float score) {
        this.significance = score;
        this.filter.setValue(score);
    }

    @Override
    public void update(Map<String, float[]> map, int scoreColumnIndex) {
        this.nodeIdToScore = DefaultNodeColorScheme.createNodeIdToScoreMap(map, scoreColumnIndex);
    }

    @Override
    public void update(Map<String, Float> map) {
        this.nodeIdToScore = DefaultNodeColorScheme.createNodeIdToScoreMap(map);
    }

    public static Map<String, Float> createNodeIdToScoreMap(Map<String, float[]> nodeIdToScores, int scoreColumnIndex) {
        HashMap<String, Float> nodeToScore = new HashMap<String, Float>();
        for (String id : nodeIdToScores.keySet()) {
            nodeToScore.put(id, Float.valueOf(nodeIdToScores.get(id)[scoreColumnIndex]));
        }
        return nodeToScore;
    }

    public static Map<String, Float> createNodeIdToScoreMap(Map<String, Float> nodeIdToScores) {
        HashMap<String, Float> nodeToScore = new HashMap<String, Float>();
        for (String id : nodeIdToScores.keySet()) {
            nodeToScore.put(id, nodeIdToScores.get(id));
        }
        return nodeToScore;
    }
}

