/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.BrowserLauncher;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.jdesktop.swingx.util.OS;

public class HelpMenu
extends JMenu {
    public HelpMenu(HeatMapPanel heatMapPanel) {
        super("Help");
        if (!OS.isMacOSX() || !Application.isStandalone()) {
            this.add(heatMapPanel.getHeatMapEditorKit().getAboutAction());
        }
        this.add(new AbstractAction(Application.getName() + " web site"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserLauncher.openURL("http://www.broadinstitute.org/cancer/software/" + Application.getName());
            }
        });
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
            this.add(new AbstractAction("Contact Us"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Desktop.getDesktop().mail(new URI("mailto:gene-e@broadinstitute.org"));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        UIUtil.showMessageDialog(UIUtil.getCurrentFrame(), "Please contact us at gene-e@broadinstitute.org.");
                    }
                }
            });
        }
    }
}

