/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import org.broadinstitute.genee.gui.Drawable;

public class HorizontalDrawableArray
implements Drawable {
    Drawable[] array;
    Dimension[] sizes;
    Dimension fullSize;

    public HorizontalDrawableArray(Collection<Drawable> drawables) {
        this(drawables.toArray(new Drawable[0]));
    }

    public HorizontalDrawableArray(Drawable ... array) {
        int i;
        this.array = array;
        this.fullSize = new Dimension();
        this.sizes = new Dimension[array.length];
        int length = array.length;
        for (i = 0; i < length; ++i) {
            if (array[i] != null) {
                Dimension size;
                this.sizes[i] = size = array[i].getDrawableSize();
                this.fullSize.width += size.width;
                this.fullSize.height = Math.max(this.fullSize.height, size.height);
                continue;
            }
            this.sizes[i] = new Dimension();
        }
        length = array.length;
        for (i = 0; i < length; ++i) {
            this.sizes[i].height = this.fullSize.height;
        }
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform saved = g2.getTransform();
        int tx = 0;
        int length = this.array.length;
        for (int i = 0; i < length; ++i) {
            if (this.array[i] == null) continue;
            g2.setTransform(saved);
            g.translate(tx, 0);
            this.array[i].draw(g, new Rectangle(this.sizes[i]));
            tx += this.sizes[i].width;
        }
        g2.setTransform(saved);
    }

    public Drawable[] getArray() {
        return this.array;
    }

    @Override
    public Dimension getDrawableSize() {
        return this.fullSize;
    }
}

