/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu.file;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.GEODatasetParser;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.GEOSeriesParser;

public class ImportFromGEO
extends AbstractAction {
    public ImportFromGEO() {
        super("GEO SOFT File\u2026");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        File file = FileChooserUtil.showOpenDialog(UIUtil.getCurrentFrame(), "Select GSE or GDS SOFT File");
        if (file != null) {
            final boolean gds = file.getName().toUpperCase().startsWith("GDS");
            final String path = IOUtil.getPath(file);
            new BackgroundTask<Project>("Importing " + file.getName()){

                @Override
                protected Project doInBackground() throws Exception {
                    return !gds ? new GEOSeriesParser(path, false).createProject() : new GEODatasetParser(path, false).createProject();
                }

                @Override
                protected void succeeded(Project p) {
                    History history = new History("Imported from GEO");
                    history.add("ID", p.getOriginalDataset().getName());
                    Application.add(new GENEEFolderNode("GEO", history, new ProjectGENEEResultTreeNode(p, history)));
                }
            }.execute();
        }
    }
}

