/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.excel;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;

public class ExcelReader {
    public static final Set<String> FILE_EXTENSIONS = new HashSet<String>();
    private ExcelReaderContentHandler contentHandler;
    private boolean isText;
    private int skipHeaderLines = 0;
    private HSSFPalette customPalette;
    private static final HSSFColor HSSF_AUTO;

    public ExcelReader(String file, ExcelReaderContentHandler contentHandler) throws IOException {
        this.contentHandler = contentHandler;
        this.parseAsExcelOrText(file, 0);
    }

    public ExcelReader(String file, int sheetIndex, ExcelReaderContentHandler contentHandler) throws IOException {
        this.contentHandler = contentHandler;
        this.parseAsExcelOrText(file, sheetIndex);
    }

    public ExcelReader(String file, String sheetName, ExcelReaderContentHandler contentHandler) throws IOException {
        this.contentHandler = contentHandler;
        this.parseAsExcelOrText(file, sheetName);
    }

    public ExcelReaderContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public boolean isText() {
        return this.isText;
    }

    private Color getColor(Cell cell) {
        try {
            if (cell == null || cell.getCellStyle() == null) {
                return null;
            }
            CellStyle style = cell.getCellStyle();
            if (style instanceof XSSFCellStyle) {
                XSSFCellStyle xCellStyle = (XSSFCellStyle)style;
                Color color = this.toAwtColor(xCellStyle.getFillForegroundXSSFColor());
                return color;
            }
            if (style instanceof HSSFCellStyle) {
                short index = style.getFillForegroundColor();
                Color color = this.toAwtColor(cell, index);
                return color;
            }
            return null;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    private void parseAsExcel(InputStream is, Object sheetIndexOrName, String file) throws IOException, InvalidFormatException {
        Workbook wb = ExcelReader.createWorkbook(file, is);
        Sheet sheet = sheetIndexOrName instanceof Integer ? wb.getSheetAt(((Integer)sheetIndexOrName).intValue()) : (sheetIndexOrName instanceof String ? wb.getSheet((String)sheetIndexOrName) : wb.getSheetAt(0));
        this.parseSheet(sheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAsExcelOrText(String file, Object sheetIndexOrName) throws IOException {
        if (file.toLowerCase().endsWith(".txt") || file.toLowerCase().endsWith(".chip")) {
            this.isText = true;
            try {
                ExcelReader._parseAsText(file, this.skipHeaderLines, this.contentHandler);
            }
            finally {
                this.contentHandler.end();
            }
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(IOUtil.getInputStream(file), 0x100000);
            this.parseAsExcel(is, sheetIndexOrName, file);
            this.isText = false;
        }
        catch (Exception e) {
            if (file.endsWith(".xlsx")) {
                e.printStackTrace();
            }
            this.isText = true;
            ExcelReader._parseAsText(file, this.skipHeaderLines, this.contentHandler);
        }
        finally {
            this.contentHandler.end();
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    private void parseSheet(Sheet sheet) {
        String txt;
        Cell cell;
        Row row = sheet.getRow(this.skipHeaderLines);
        int columns = row.getLastCellNum() + 1;
        for (int c = columns - 1; c >= 0; --c) {
            boolean nonNull = false;
            int rows = sheet.getLastRowNum();
            for (int r = 0; r <= rows; ++r) {
                cell = row.getCell(c);
                txt = ExcelReader.getStringCellValue(cell);
                if (txt == null || "".equals(txt)) continue;
                nonNull = true;
                break;
            }
            if (nonNull) break;
            --columns;
        }
        this.contentHandler.init(sheet.getLastRowNum() + 1 - this.skipHeaderLines, columns);
        int rows = sheet.getLastRowNum();
        for (int r = this.skipHeaderLines; r <= rows; ++r) {
            row = sheet.getRow(r);
            if (!this.contentHandler.nextRow()) {
                return;
            }
            boolean allColumnsAreNull = true;
            if (row != null) {
                for (int c = 0; c < columns; ++c) {
                    cell = row.getCell(c);
                    txt = ExcelReader.getStringCellValue(cell);
                    Color bg = this.getColor(cell);
                    if (bg != null) {
                        this.contentHandler.color(c, txt, bg);
                    }
                    if (allColumnsAreNull && txt != null && !txt.equals("")) {
                        allColumnsAreNull = false;
                    }
                    this.contentHandler.value(c, txt != null ? new String(txt) : "");
                }
            }
            if (!allColumnsAreNull) continue;
            return;
        }
    }

    private Color toAwtColor(Cell cell, short index) {
        if (this.customPalette == null) {
            this.customPalette = ((HSSFWorkbook)cell.getSheet().getWorkbook()).getCustomPalette();
        }
        HSSFColor color = this.customPalette.getColor(index);
        if (index == HSSF_AUTO.getIndex() || color == null) {
            return null;
        }
        short[] rgbArray = color.getTriplet();
        if (rgbArray == null) {
            return null;
        }
        int[] rgb = new int[3];
        for (int n : rgbArray) {
            if (n < 0) {
                n += 256;
            }
            rgb[i] = n;
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    private Color toAwtColor(XSSFColor color) {
        if (color == null || color.isAuto()) {
            return null;
        }
        byte[] rgbArray = color.getRgb();
        if (rgbArray == null) {
            return null;
        }
        int[] rgb = new int[3];
        for (int n : rgbArray) {
            if (n < 0) {
                n += 256;
            }
            rgb[i] = n;
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(int[] columnIndices, String[] columnNames, String file, String outputFile) throws IOException {
        Array2DContentHandler handler = new Array2DContentHandler();
        new ExcelReader(file, handler);
        String[][] data = handler.getData();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            if (columnNames != null) {
                int length = columnNames.length;
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        pw.print("\t");
                    }
                    pw.print(columnNames[i]);
                }
                pw.println();
            }
            int ncols = columnIndices.length;
            for (String[] array : data) {
                for (int j = 0; j < ncols; ++j) {
                    if (j > 0) {
                        pw.print("\t");
                    }
                    pw.print(array[columnIndices[j]]);
                }
                pw.println();
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSheetCount(String file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(IOUtil.getInputStream(file), 0x100000);
            Workbook wb = ExcelReader.createWorkbook(file, is);
            int n = wb.getNumberOfSheets();
            return n;
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSheetNames(String file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(IOUtil.getInputStream(file), 0x100000);
            Workbook wb = ExcelReader.createWorkbook(file, is);
            String[] sheetNames = new String[wb.getNumberOfSheets()];
            int length = sheetNames.length;
            for (int i = 0; i < length; ++i) {
                sheetNames[i] = wb.getSheetName(i);
            }
            String[] stringArray = sheetNames;
            return stringArray;
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return new String[0];
    }

    public static String getStringCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 0) {
            Date date;
            if (DateUtil.isCellDateFormatted((Cell)cell) && (date = DateUtil.getJavaDate((double)cell.getNumericCellValue())) != null) {
                return Formatter.format(date);
            }
            if (cell instanceof XSSFCell) {
                return ((XSSFCell)cell).getRawValue();
            }
            double value = cell.getNumericCellValue();
            return Formatter.format(value);
        }
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 2) {
            System.err.println("Formulas are not supported.");
            return null;
        }
        return cell.getStringCellValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExcelFile(String file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(IOUtil.getInputStream(file));
            WorkbookFactory.create((InputStream)is);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseAsText(InputStream is, char sep, int skip, ExcelReaderContentHandler contentHandler) throws IOException {
        try {
            ExcelReader._parseAsText(is, sep, skip, contentHandler);
        }
        finally {
            contentHandler.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void _parseAsText(InputStream is, char sep, int skip, ExcelReaderContentHandler contentHandler) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is), 0x100000);
            for (int i = 0; i < skip; ++i) {
                br.readLine();
            }
            String[] header = br.readLine().split(String.valueOf(sep));
            int columns = header.length;
            contentHandler.init(-1, columns);
            if (!contentHandler.nextRow()) {
                return;
            }
            for (int j = 0; j < columns; ++j) {
                contentHandler.value(j, header[j]);
            }
            String[] tokens = new String[columns];
            block18: while (true) {
                String s;
                if ((s = br.readLine()) == null) return;
                if (s.equals("")) {
                    return;
                }
                if (!contentHandler.nextRow()) {
                    return;
                }
                IOUtil.split(s, tokens, sep);
                int j = 0;
                while (true) {
                    if (j >= columns) continue block18;
                    contentHandler.value(j, new String(tokens[j].trim()));
                    ++j;
                }
                break;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static void _parseAsText(String file, int skipHeaderLines, ExcelReaderContentHandler contentHandler) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)), 0x100000);
        for (int i = 0; i < skipHeaderLines; ++i) {
            br.readLine();
        }
        String headerLine = br.readLine();
        if (headerLine == null) {
            throw new NullPointerException("Header line is null.");
        }
        String[] headerTokens = headerLine.split("\t");
        char sep = '\t';
        if (headerTokens.length <= 1) {
            sep = ',';
        }
        br.close();
        ExcelReader._parseAsText(IOUtil.getInputStream(file), sep, skipHeaderLines, contentHandler);
    }

    private static Workbook createWorkbook(String file, InputStream is) throws IOException, InvalidFormatException {
        Workbook wb = null;
        if (file != null) {
            if (file.toLowerCase().endsWith(".xlsx")) {
                wb = new XSSFWorkbook(OPCPackage.open((InputStream)is));
            } else if (file.toLowerCase().endsWith(".xls")) {
                wb = new HSSFWorkbook(is);
            }
        }
        if (wb == null) {
            wb = WorkbookFactory.create((InputStream)is);
        }
        return wb;
    }

    static {
        FILE_EXTENSIONS.add("xls");
        FILE_EXTENSIONS.add("gin");
        FILE_EXTENSIONS.add("sin");
        HSSF_AUTO = new HSSFColor.AUTOMATIC();
    }
}

