/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.luminex;

import au.com.bytecode.opencsv.CSVReader;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.io.matrix.dchip.AbstractSampleInfoFile;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class LuminexCsvParser {
    public static final String DATA_TYPE_COUNT = "Count";
    public static final String DATA_TYPE_CV = "%CV";
    public static final String DATA_TYPE_MEAN = "Mean";
    public static final String DATA_TYPE_MEDIAN = "Median";
    public static final String DATA_TYPE_PEAK = "Peak";
    public static final String DATA_TYPE_STD_DEV = "Std Dev";
    public static final String DATA_TYPE_TRIMMED_COUNT = "Trimmed Count";
    public static final String DATA_TYPE_TRIMMED_CV_OF_MICROSPHERES = "Trimmed % CV of Microspheres";
    public static final String DATA_TYPE_TRIMMED_MEAN = "Trimmed Mean";
    public static final String DATA_TYPE_TRIMMED_PEAK = "Trimmed Peak";
    public static final String DATA_TYPE_TRIMMED_STD_DEV = "Trimmed Standard Deviation";
    private static final String DATA_TYPE = "DataType:";
    private CSVReader csvReader;
    private RowMajorArray2DDataset dataset;
    private String file;
    private TIntArrayList plateColumns;
    private ArrayList<String> plateRows;
    private boolean stripLocationPrefix = true;
    private boolean threeLetterWellNames = true;
    public static final String METADATA_DATE = "Date";
    public static final String METADATA_SCANNER_NAME = "SN";
    public static final String METADATA_BATCH = "Batch";
    public static final String METADATA_BATCH_START_TIME = "BatchStartTime";
    public static final String METADATA_BATCH_STOP_TIME = "BatchStopTime";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuminexCsvParser(String file, String dataType) throws IOException {
        this.file = file;
        try {
            String[] line;
            String type;
            this.csvReader = new CSVReader((Reader)new InputStreamReader(IOUtil.getInputStream(file)));
            do {
                if ((line = this.readNext()) != null) continue;
                throw new IllegalArgumentException("Data type " + dataType + " not found in " + file + ".");
            } while (!(type = line[0].trim()).equals(DATA_TYPE) || !dataType.equals(line[1].trim()));
            this.parseDataType();
        }
        finally {
            if (this.csvReader != null) {
                try {
                    this.csvReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public RowMajorArray2DDataset getDataset() {
        return this.dataset;
    }

    public String getFile() {
        return this.file;
    }

    public boolean isStripLocationPrefix() {
        return this.stripLocationPrefix;
    }

    public boolean isThreeLetterWellNames() {
        return this.threeLetterWellNames;
    }

    public void rename(AbstractSampleInfoFile wellLookupTable, AbstractSampleInfoFile beadLookupTable) throws MissingMappingException {
        if (wellLookupTable != null) {
            LuminexCsvParser.addToMetadata(this.dataset.getRowMetadata(), wellLookupTable, true);
        }
        if (beadLookupTable != null) {
            LuminexCsvParser.addToMetadata(this.dataset.getColumnMetadata(), beadLookupTable, false);
            Vector beads = this.dataset.getColumnMetadata().get("Bead");
            beads.setProperty("Text Visible", null);
        }
    }

    private void addWellMetadata() {
        int i;
        Vector row = MetadataUtil.addRowVector(this.dataset.getRowMetadata(), "plate row", String.class);
        Vector column = MetadataUtil.addRowVector(this.dataset.getRowMetadata(), "plate column", Integer.class);
        Vector plate = MetadataUtil.addRowVector(this.dataset.getRowMetadata(), "plate", String.class);
        String fileName = new File(this.getFile()).getName();
        int rows = this.dataset.getRowCount();
        for (i = 0; i < rows; ++i) {
            plate.setValue(i, fileName);
        }
        rows = this.dataset.getRowCount();
        for (i = 0; i < rows; ++i) {
            row.setValue(i, this.plateRows.get(i));
            column.setValue(i, this.plateColumns.get(i));
        }
    }

    private void parseDataType() throws IOException {
        String[] line;
        ArrayList<float[]> data = new ArrayList<float[]>();
        ArrayList<String> wells = new ArrayList<String>();
        String[] headerLine = this.readNext();
        int dataColumns = headerLine.length - 3;
        this.plateRows = new ArrayList();
        this.plateColumns = new TIntArrayList();
        while ((line = this.readNext()) != null && !line[0].trim().equals("")) {
            int column;
            String rowCharacter;
            String well = line[0];
            if (line.length == 2) continue;
            if (this.stripLocationPrefix) {
                well = well.substring(well.indexOf(44) + 1, well.length() - 1);
                rowCharacter = well.substring(0, 1);
                column = Integer.parseInt(well.substring(1));
                StringBuilder sb = new StringBuilder();
                if (this.threeLetterWellNames && well.length() < 3) {
                    sb.append(well.substring(0, 1)).append("0").append(well.substring(1, well.length())).toString();
                } else {
                    sb.append(well);
                }
                well = sb.toString();
            } else {
                int commaIdx = well.indexOf(44);
                rowCharacter = well.substring(commaIdx + 1, commaIdx + 2);
                String columnString = well.substring(commaIdx + 2, well.length() - 1);
                column = Integer.parseInt(columnString);
            }
            this.plateRows.add(rowCharacter);
            this.plateColumns.add(column);
            wells.add(well);
            float[] row = new float[dataColumns];
            int length = line.length - 1;
            for (int j = 2; j < length; ++j) {
                String s = line[j];
                try {
                    row[j - 2] = ParserHelper.parseFloatNaN(s);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Unable to parse " + s + " for location " + well + " at analyte number " + (j - 1) + ".");
                }
            }
            data.add(row);
        }
        int ncols = data.size() == 0 ? 0 : ((float[])data.get(0)).length;
        float[][] array = new float[data.size()][ncols];
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            array[i] = (float[])data.get(i);
        }
        this.dataset = new RowMajorArray2DDataset(new File(this.file).getName(), array);
        Vector beads = MetadataUtil.addRowVector(this.dataset.getColumnMetadata(), "Bead", String.class);
        int size2 = headerLine.length - 1;
        for (int i = 2; i < size2; ++i) {
            String analyte = headerLine[i];
            beads.setValue(i - 2, analyte);
        }
        Vector wellVector = MetadataUtil.addRowVector(this.dataset.getRowMetadata(), "Well", String.class);
        int size3 = data.size();
        for (int i = 0; i < size3; ++i) {
            wellVector.setValue(i, wells.get(i));
        }
        this.addWellMetadata();
    }

    private String[] readNext() throws IOException {
        String[] line = this.csvReader.readNext();
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMetadata(String file) throws IOException {
        CSVReader csvReader = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String[] line;
            csvReader = new CSVReader((Reader)new InputStreamReader(IOUtil.getInputStream(file)));
            while ((line = csvReader.readNext()) != null) {
                String firstColumn = line[0].trim();
                if (firstColumn.equals(DATA_TYPE)) {
                    break;
                }
                if (line.length <= 1) continue;
                map.put(firstColumn, line[1].trim());
            }
        }
        finally {
            if (csvReader != null) {
                try {
                    csvReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return map;
    }

    private static void addToMetadata(MetadataModel metadata, AbstractSampleInfoFile lookupTable, boolean isWell) {
        List<String> names = lookupTable.getColumnNames();
        Vector[] vectors = new Vector[names.size()];
        int size = names.size();
        for (int i = 0; i < size; ++i) {
            String name = names.get(i);
            vectors[i] = MetadataUtil.addRowVector(metadata, name, String.class);
        }
        Vector beadVector = !isWell ? metadata.get("Bead") : null;
        int nitems = metadata.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            String beadOrWell = (String)(isWell ? LuminexCsvParser.getWell(metadata, i) : beadVector.getValue(i));
            int rowIndex = lookupTable.idToRowIndex(beadOrWell);
            if (rowIndex == -1) continue;
            int size2 = names.size();
            for (int metadataIndex = 0; metadataIndex < size2; ++metadataIndex) {
                Vector v = vectors[metadataIndex];
                v.setValue(i, lookupTable.getValue(rowIndex, metadataIndex));
            }
        }
    }

    private static String getWell(MetadataModel metadata, int index) {
        String row = (String)metadata.getValue(index, "plate row");
        Integer column = (Integer)metadata.getValue(index, "plate column");
        if (column == null) {
            throw new NullPointerException("No plate column at row index " + index + ".");
        }
        StringBuilder sb = new StringBuilder(row);
        if (column < 10) {
            sb.append("0");
        }
        sb.append(column);
        return sb.toString();
    }

    public static class MissingMappingException
    extends Exception {
        private String batch;
        private List<String> missingAnalytes;
        private List<String> missingLocations;

        MissingMappingException(String batch, List<String> missingLocations, List<String> missingAnalytes) {
            this.missingLocations = missingLocations;
            this.missingAnalytes = missingAnalytes;
            this.batch = batch;
        }

        @Override
        public String getMessage() {
            StringBuilder buf = new StringBuilder();
            buf.append("In file " + this.batch + " ");
            if (this.missingLocations.size() > 0) {
                buf.append("missing locations ");
                buf.append(this.missingLocations);
            }
            if (this.missingAnalytes.size() > 0) {
                buf.append("missing analytes ");
                buf.append(this.missingAnalytes);
            }
            return buf.toString();
        }

        public List<String> getMissingAnalytes() {
            return this.missingAnalytes;
        }

        public List<String> getMissingLocations() {
            return this.missingLocations;
        }
    }
}

