/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class GEODatasetParser {
    private BufferedReader br;
    private Map<String, Map<String, String>> categoryToSampleToValue = new HashMap<String, Map<String, String>>();
    private RowMajorArray2DDataset dataset;
    private String[] columnNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GEODatasetParser(String file, boolean headerOnly) throws IOException {
        try {
            String s;
            int rows = 0;
            Subset subset = null;
            ArrayList<Subset> subsets = new ArrayList<Subset>();
            this.br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)));
            while ((s = this.br.readLine()) != null && !s.startsWith("!dataset_table_begin")) {
                if (s.startsWith("!dataset_feature_count")) {
                    rows = Integer.parseInt(s.substring(s.indexOf(61) + 1).trim());
                    continue;
                }
                if (s.startsWith("^SUBSET")) {
                    subset = new Subset();
                    subsets.add(subset);
                    continue;
                }
                if (s.startsWith("!subset_sample_id")) {
                    subset.ids = s.substring(s.indexOf(61) + 1).split(",");
                    continue;
                }
                if (s.startsWith("!subset_description")) {
                    subset.value = s.substring(s.indexOf(61) + 1).trim();
                    continue;
                }
                if (!s.startsWith("!subset_type")) continue;
                subset.category = s.substring(s.indexOf(61) + 1).trim();
            }
            for (Subset ss : subsets) {
                if (ss.ids == null || ss.category == null) continue;
                Map<String, String> sampleToValue = this.categoryToSampleToValue.get(ss.category);
                if (sampleToValue == null) {
                    sampleToValue = new HashMap<String, String>();
                    this.categoryToSampleToValue.put(ss.category, sampleToValue);
                }
                for (String id : ss.ids) {
                    sampleToValue.put(id.trim(), ss.value);
                }
            }
            String header = this.br.readLine();
            String[] headerTokens = IOUtil.split(header);
            int cols = headerTokens.length - 2;
            this.columnNames = new String[cols];
            for (int j = 0; j < cols; ++j) {
                String id;
                this.columnNames[j] = id = headerTokens[j + 2];
            }
            if (!headerOnly) {
                this.dataset = new RowMajorArray2DDataset(file, rows, cols);
                Vector ids = MetadataUtil.addRowVector(this.dataset.getColumnMetadata(), "Id", String.class);
                for (int j = 0; j < cols; ++j) {
                    ids.setValue(j, this.columnNames[j]);
                }
                Vector rowIds = MetadataUtil.addRowVector(this.dataset.getRowMetadata(), "Id", String.class);
                MetadataUtil.addRowVector(this.dataset.getRowMetadata(), headerTokens[1], String.class);
                String[] tokens = new String[headerTokens.length];
                for (int i = 0; i < rows; ++i) {
                    s = this.br.readLine();
                    IOUtil.split(s, tokens, '\t');
                    rowIds.setValue(i, tokens[0]);
                    this.dataset.getRowMetadata().setValue(i, headerTokens[1], (Object)tokens[1]);
                    for (int j = 0; j < cols; ++j) {
                        this.dataset.setValue(i, j, ParserHelper.parseFloatNaN(tokens[j + 2]));
                    }
                }
            }
        }
        finally {
            if (this.br != null) {
                this.br.close();
            }
        }
    }

    public Project createProject() {
        DefaultProject p = new DefaultProject(this.dataset);
        for (String category : this.categoryToSampleToValue.keySet()) {
            Vector v = MetadataUtil.addColumnVector(p.getOriginalDataset().getColumnMetadata(), category, String.class);
            Map<String, String> sampleToValue = this.categoryToSampleToValue.get(category);
            int cols = this.dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                String value = sampleToValue.get(this.columnNames[j]);
                v.setValue(j, value);
            }
        }
        return p;
    }

    public Map<String, Map<String, String>> getCategoryToSampleToValue() {
        return this.categoryToSampleToValue;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    private static class Subset {
        String category;
        String[] ids;
        String value;

        private Subset() {
        }
    }
}

