/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class ListFileWriter
implements ProjectWriter {
    private boolean rowMajorOrder = true;
    public static final String FORMAT = "List Row";

    @Override
    public String checkFileExtension(String filename) {
        if (filename.indexOf(46) == -1) {
            filename = filename + ".txt";
        }
        return filename;
    }

    @Override
    public String getFormatName() {
        return FORMAT;
    }

    @Override
    public void write(Project project, PrintWriter pw) throws IOException {
        int i;
        Dataset dataset = project.getSortedFilteredDataset();
        if (!this.rowMajorOrder) {
            dataset = DatasetUtil.transposeView(dataset);
        }
        TIntArrayList seriesIndices = new TIntArrayList();
        int size = dataset.getSeriesCount();
        for (i = 0; i < size; ++i) {
            if (!Number.class.isAssignableFrom(dataset.getSeriesClass(i)) && !Float.TYPE.isAssignableFrom(dataset.getSeriesClass(i))) continue;
            seriesIndices.add(i);
        }
        int nseries = seriesIndices.size();
        for (i = 0; i < nseries; ++i) {
            if (i > 0) {
                pw.print("\t");
            }
            pw.print(dataset.getSeriesName(seriesIndices.getQuick(i)));
        }
        int metadataCount = dataset.getRowMetadata().getMetadataCount();
        for (i = 0; i < metadataCount; ++i) {
            pw.print("\t");
            pw.print(dataset.getRowMetadata().getColumnName(i));
        }
        metadataCount = dataset.getColumnMetadata().getMetadataCount();
        for (i = 0; i < metadataCount; ++i) {
            pw.print("\t");
            pw.print(dataset.getColumnMetadata().getColumnName(i));
        }
        pw.println();
        int nrows = dataset.getRowCount();
        for (i = 0; i < nrows; ++i) {
            int ncols = dataset.getColumnCount();
            for (int j = 0; j < ncols; ++j) {
                int k;
                int nseries2 = seriesIndices.size();
                for (k = 0; k < nseries2; ++k) {
                    if (k > 0) {
                        pw.print("\t");
                    }
                    pw.print(Formatter.format(dataset.getValue(i, j, seriesIndices.getQuick(k))));
                }
                int metadataCount2 = dataset.getRowMetadata().getMetadataCount();
                for (k = 0; k < metadataCount2; ++k) {
                    pw.print("\t");
                    pw.print(Formatter.toString(dataset.getRowMetadata().getValue(i, k)));
                }
                metadataCount2 = dataset.getColumnMetadata().getMetadataCount();
                for (k = 0; k < metadataCount2; ++k) {
                    pw.print("\t");
                    pw.print(Formatter.toString(dataset.getColumnMetadata().getValue(j, k)));
                }
                pw.println();
            }
        }
    }
}

