/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.dchip;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.io.util.IOUtil;

public abstract class AbstractSampleInfoFile {
    private Map<Object, Integer> keyToRowIndex;
    private String[][] matrix;
    private String[] columnNames;
    private Map<String, Integer> columnNameToIndex;
    private int[] columnIndices;

    public AbstractSampleInfoFile(String[][] matrix, int[] columnIndices) throws IOException {
        int i;
        int length;
        this.matrix = matrix;
        this.columnIndices = columnIndices;
        this.columnNames = matrix[0];
        if (columnIndices != null) {
            this.columnNames = new String[columnIndices.length];
            length = columnIndices.length;
            for (i = 0; i < length; ++i) {
                this.columnNames[i] = matrix[0][columnIndices[i]];
            }
        }
        this.columnNameToIndex = IOUtil.buildIndexMap(Arrays.asList(this.columnNames));
        this.keyToRowIndex = new HashMap<Object, Integer>();
        length = matrix.length;
        for (i = 1; i < length; ++i) {
            this.keyToRowIndex.put(this.createKey(matrix[i]), i);
        }
    }

    public int getColumnIndex(String columnName) {
        Integer index = this.columnNameToIndex.get(columnName);
        return index != null ? index : -1;
    }

    public List<String> getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public int getRowCount() {
        return this.matrix.length - 1;
    }

    public int idToRowIndex(Object key) {
        Integer rowIndex = this.keyToRowIndex.get(key);
        return rowIndex == null ? -1 : rowIndex - 1;
    }

    public String getValue(int rowIndex, int columnIndex) {
        String[] array = this.matrix[rowIndex + 1];
        if (columnIndex < 0 || columnIndex >= array.length) {
            return null;
        }
        return this.columnIndices == null ? array[columnIndex] : array[this.columnIndices[columnIndex]];
    }

    public String getValue(int rowIndex, String column) {
        int columnIndex = this.getColumnIndex(column);
        return this.getValue(rowIndex, columnIndex);
    }

    protected abstract Object createKey(String[] var1);
}

