/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gct;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class GctReader
implements ProjectReader {
    private int rows;
    private int ncols;
    private List<String> suffixes = Collections.unmodifiableList(Arrays.asList("gct"));
    private Pattern pipePatten;
    private Pattern equalsPattern;

    @Override
    public List<String> getFileSuffixes() {
        return this.suffixes;
    }

    @Override
    public String getFormatName() {
        return "gct";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project read(String file) throws IOException {
        InputStream is = null;
        try {
            is = IOUtil.getInputStream(file);
            DefaultProject defaultProject = new DefaultProject(this.read(IOUtil.getName(file), is));
            return defaultProject;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Dataset read(String datasetName, InputStream is) throws IOException {
        int j;
        int expectedColumns;
        RowMajorArray2DDataset dataset;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(is), 0x100000);
        String versionLine = reader.readLine().trim();
        String dimensionsLine = reader.readLine().trim();
        String columnNamesLine = reader.readLine();
        int version = 2;
        if ("#1.2".equals(versionLine)) {
            version = 2;
        } else if ("#1.3".equals(versionLine)) {
            version = 3;
        }
        String[] dimensions = IOUtil.split(dimensionsLine);
        int numRowAnnotations = 1;
        int numColumnAnnotations = 0;
        try {
            this.rows = Integer.parseInt(dimensions[0]);
            this.ncols = Integer.parseInt(dimensions[1]);
            dataset = new RowMajorArray2DDataset(datasetName, this.rows, this.ncols);
            if (version == 3) {
                numRowAnnotations = Integer.parseInt(dimensions[2]);
                numColumnAnnotations = Integer.parseInt(dimensions[3]);
            }
        }
        catch (NumberFormatException nfe) {
            if (version == 2) {
                throw new IOException("Line number " + reader.getLineNumber() + " should contain the number of rows and the number of columns separated by a tab.");
            }
            throw new IOException("Line number " + reader.getLineNumber() + " should contain the number of rows, the number of columns, the number of row annotations, and the number of column annotations separated by a tab.");
        }
        if (this.rows <= 0 || this.ncols <= 0) {
            throw new IOException("Number of rows and columns must be greater than 0.");
        }
        String[] columnNamesArray = IOUtil.split(columnNamesLine);
        if (version == 2 && columnNamesArray.length != (expectedColumns = this.ncols + 2)) {
            throw new IOException("Expected " + (expectedColumns - 2) + " column names, but read " + (columnNamesArray.length - 2) + " column names on line " + reader.getLineNumber() + ".");
        }
        if (columnNamesArray.length != this.ncols + numRowAnnotations + 1) {
            throw new IOException("Expected " + this.ncols + " columns.");
        }
        String name = columnNamesArray[0];
        int slashIndex = name.lastIndexOf(47);
        String columnIdFieldName = "Id";
        String rowIdFieldName = "Id";
        if (slashIndex != -1 && slashIndex < name.length() - 1) {
            rowIdFieldName = name.substring(0, slashIndex).trim();
            columnIdFieldName = name.substring(slashIndex + 1).trim();
        }
        Vector columnIds = MetadataUtil.addRowVector(dataset.getColumnMetadata(), columnIdFieldName, String.class);
        for (j = 0; j < this.ncols; ++j) {
            String columnName = columnNamesArray[j + numRowAnnotations + 1];
            columnIds.setValue(j, columnName);
        }
        MetadataUtil.addRowVector(dataset.getRowMetadata(), rowIdFieldName, String.class);
        if (version == 3) {
            for (j = 0; j < numRowAnnotations; ++j) {
                String desc = "".equals(columnNamesArray[1]) ? "Description" : columnNamesArray[j + 1];
                MetadataUtil.addRowVector(dataset.getRowMetadata(), desc, String.class);
            }
        }
        int dataColumnStart = numRowAnnotations + 1;
        int ntokens = this.ncols + numRowAnnotations + 1;
        String[] tokens = new String[ntokens];
        if (numColumnAnnotations > 0) {
            for (int columnAnnotationIndex = 0; columnAnnotationIndex < numColumnAnnotations; ++columnAnnotationIndex) {
                String line = reader.readLine();
                IOUtil.split(line, tokens, '\t');
                Vector v = MetadataUtil.addRowVector(dataset.getColumnMetadata(), tokens[0], String.class);
                for (int j2 = 0; j2 < this.ncols; ++j2) {
                    v.setValue(j2, tokens[j2 + dataColumnStart]);
                }
            }
        }
        int rowIndex = 0;
        this.pipePatten = Pattern.compile("\\|");
        this.equalsPattern = Pattern.compile("=");
        if (version == 2) {
            for (int j3 = 0; j3 < this.ncols; ++j3) {
                columnIds.setValue(j3, this.pipeSplit(dataset.getColumnMetadata(), 1, j3, 0, (String)columnIds.getValue(j3), false));
            }
        }
        String s = reader.readLine();
        while (true) {
            block32: {
                block33: {
                    block30: {
                        block31: {
                            if (s == null) break block30;
                            if (rowIndex < this.rows) break block31;
                            if (!s.trim().equals("")) {
                                int rowsRead = rowIndex + 1;
                                throw new IOException("More data rows than expected on line " + reader.getLineNumber() + ". Read " + rowsRead + ", expected " + this.rows + ".");
                            }
                            --rowIndex;
                            break block32;
                        }
                        IOUtil.split(s, tokens, '\t');
                        if (version == 2) {
                            dataset.getRowMetadata().setValue(rowIndex, 0, (Object)new String(tokens[0]));
                            String rowMetadataValue = this.pipeSplit(dataset.getRowMetadata(), 0, rowIndex, -1, tokens[1], true);
                            if (rowMetadataValue != null && !rowMetadataValue.equals("")) {
                                int descVectorIndex = dataset.getRowMetadata().getColumnIndex("Description");
                                if (descVectorIndex == -1) {
                                    MetadataUtil.addRowVector(dataset.getRowMetadata(), "Description", String.class);
                                    descVectorIndex = dataset.getRowMetadata().getColumnIndex("Description");
                                }
                                dataset.getRowMetadata().setValue(rowIndex, descVectorIndex, (Object)new String(rowMetadataValue));
                            }
                            break block33;
                        } else {
                            int length = numRowAnnotations + 1;
                            for (int rowAnnotationIndex = 0; rowAnnotationIndex < length; ++rowAnnotationIndex) {
                                String rowMetadataValue = tokens[rowAnnotationIndex];
                                if (rowMetadataValue == null || rowMetadataValue.equals("")) continue;
                                dataset.getRowMetadata().setValue(rowIndex, rowAnnotationIndex, (Object)new String(rowMetadataValue));
                            }
                        }
                        break block33;
                    }
                    if (rowIndex != this.rows) {
                        throw new IOException("Missing data rows. Read " + rowIndex + " " + this.getRowString(rowIndex) + ", expected " + this.rows);
                    }
                    return dataset;
                }
                for (int columnIndex = 0; columnIndex < this.ncols; ++columnIndex) {
                    String token = tokens[columnIndex + dataColumnStart];
                    try {
                        dataset.setValue(rowIndex, columnIndex, ParserHelper.parseFloatNaN(token));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException(token + " at line number " + reader.getLineNumber() + " and column " + columnIndex + " is not a number.");
                    }
                }
            }
            s = reader.readLine();
            ++rowIndex;
        }
    }

    protected String getColumnString(int cols) {
        if (cols == 1) {
            return "column";
        }
        return "columns";
    }

    protected String getRowString(int rows) {
        if (rows == 1) {
            return "row";
        }
        return "rows";
    }

    private String pipeSplit(MetadataModel metadata, int startPipeTokenIndex, int metadataRowIndex, int pipeTokenValueIndex, String text, boolean isRows) {
        String[] pipeTokens = this.pipePatten.split(text);
        if (pipeTokens.length > 1) {
            int length = pipeTokens.length;
            for (int k = startPipeTokenIndex; k < length; ++k) {
                int metadataColumnIndex;
                String metadataValue;
                String token = pipeTokens[k];
                String[] equalsTokens = this.equalsPattern.split(token);
                if (equalsTokens.length == 2) {
                    String metadataName = equalsTokens[0];
                    metadataValue = equalsTokens[1];
                    metadataColumnIndex = metadata.getColumnIndex(metadataName);
                    if (metadataColumnIndex == -1) {
                        if (isRows) {
                            MetadataUtil.addRowVector(metadata, metadataName, String.class);
                        } else {
                            MetadataUtil.addColumnVector(metadata, metadataName, String.class);
                        }
                        metadataColumnIndex = metadata.getColumnIndex(metadataName);
                    }
                } else {
                    return text;
                }
                metadata.setValue(metadataRowIndex, metadataColumnIndex, (Object)metadataValue);
            }
        }
        return text;
    }
}

