/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gct;

import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.matrix.gct.GctDatasetWriter13;
import org.broadinstitute.genee.io.util.DefaultStringConverter;
import org.broadinstitute.genee.matrix.Dataset;

public class GctWriter13
implements ProjectWriter {
    public static final String FORMAT_NAME = "gct";

    @Override
    public String checkFileExtension(String filename) {
        if (!filename.toLowerCase().endsWith(".gct")) {
            filename = filename + ".gct";
        }
        return filename;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    @Override
    public void write(Project project, PrintWriter pw) throws IOException {
        Dataset dataset = project.getSortedFilteredDataset();
        new GctDatasetWriter13(new DefaultStringConverter()).write(dataset, pw);
    }
}

