/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gctx;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;

public class GctxProjectReader
implements ProjectReader {
    private static final List<String> SUFFIXES = Arrays.asList("h5", "gctx");

    @Override
    public List<String> getFileSuffixes() {
        return SUFFIXES;
    }

    @Override
    public String getFormatName() {
        return "gctx";
    }

    @Override
    public Project read(String path) throws IOException {
        return this.read(path, null, null, true);
    }

    public Project read(String path, int[] rowIndices, int[] columnIndices, boolean indicesAreSorted) throws IOException {
        File tmpFile = null;
        if (!new File(path).exists()) {
            tmpFile = File.createTempFile(IOUtil.getBaseFileName(path), ".gctx");
            IOUtil.download(path, tmpFile);
            path = tmpFile.getCanonicalPath();
        }
        GctxReader reader = null;
        try {
            Dendrogram dend;
            reader = new GctxReader(path);
            Dataset d = reader.read(rowIndices, columnIndices, true, true, indicesAreSorted);
            DefaultProject project = new DefaultProject(d);
            if (rowIndices == null && (dend = reader.getDendrogram(d.getRowMetadata(), true)) != null) {
                project.setRowDendrogram(dend);
            }
            if (columnIndices == null && (dend = reader.getDendrogram(d.getColumnMetadata(), false)) != null) {
                project.setColumnDendrogram(dend);
            }
            project.getOriginalDataset().setProperty("genee.options", reader.getGENEEOptions());
            DefaultProject defaultProject = project;
            return defaultProject;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }
}

