/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.geneset;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetMatrixReader;
import org.broadinstitute.genee.io.matrix.geneset.GmtReader;
import org.broadinstitute.genee.io.matrix.geneset.GmtWriter;
import org.broadinstitute.genee.io.matrix.geneset.GmxReader;
import org.broadinstitute.genee.io.matrix.geneset.GmxWriter;
import org.broadinstitute.genee.io.matrix.geneset.GrpReader;
import org.broadinstitute.genee.io.matrix.geneset.GrpWriter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;

public class GeneSetIO {
    private static Map<String, GeneSetMatrixReader> formatNameToReader = new HashMap<String, GeneSetMatrixReader>();

    public static Dataset asDataset(GeneSetMatrix matrix) {
        HashSet<String> uniqueIds = new HashSet<String>();
        for (GeneSet set : matrix.getGeneSets()) {
            Set<String> members = set.getMembers();
            uniqueIds.addAll(members);
        }
        ArrayList uniqueIdsList = new ArrayList(uniqueIds);
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(matrix.toString(), uniqueIds.size(), matrix.getNumGeneSets());
        Vector columnIds = dataset.getColumnMetadata().add("id", String.class);
        int size = matrix.getNumGeneSets();
        for (int j = 0; j < size; ++j) {
            columnIds.setValue(j, matrix.get(j).getName());
        }
        Vector rowIds = dataset.getRowMetadata().add("id", String.class);
        int size2 = uniqueIdsList.size();
        for (int i = 0; i < size2; ++i) {
            rowIds.setValue(i, uniqueIdsList.get(i));
        }
        Map rowIdToIndex = VectorUtil.createValueToIndexMap(rowIds);
        int size3 = matrix.getNumGeneSets();
        for (int j = 0; j < size3; ++j) {
            Set<String> ids = matrix.get(j).getMembers();
            for (String id : ids) {
                dataset.setValue(rowIdToIndex.get(id), j, 1.0f);
            }
        }
        return dataset;
    }

    public static String getNameNoJunk(GeneSet set) {
        String setName = set.getName();
        if (setName.lastIndexOf(35) != -1) {
            setName = setName.substring(setName.lastIndexOf(35) + 1);
        }
        return setName;
    }

    public static GeneSetMatrix readGeneSetMatrix(File f) throws IOException {
        return GeneSetIO.readGeneSetMatrix(IOUtil.getPath(f));
    }

    public static GeneSetMatrix readGeneSetMatrix(String file) throws IOException {
        String extension = IOUtil.getExtension(file);
        GeneSetMatrixReader reader = formatNameToReader.get(extension);
        if (reader == null) {
            throw new IOException("Unable to determine file type of " + file + ".");
        }
        return reader.read(file);
    }

    public static GeneSetMatrix readMSigDB(File file) {
        return null;
    }

    public static void saveGmt(GeneSetMatrix matrix, File file) throws IOException {
        new GmtWriter().save(matrix, file);
    }

    public static void saveGmx(GeneSetMatrix matrix, File file) throws IOException {
        new GmxWriter().save(matrix, file);
    }

    public static void saveGrp(GeneSet set, File file) throws IOException {
        new GrpWriter().save(set, file);
    }

    static {
        formatNameToReader.put("grp", new GrpReader());
        formatNameToReader.put("gmx", new GmxReader());
        formatNameToReader.put("gmt", new GmtReader());
    }
}

