/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.plate;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.io.matrix.plate.PlateFileInfo;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

public class SpectraMaxFileInfo
implements PlateFileInfo {
    private static final int DATA_COLUMN_START = 2;
    private BufferedReader br;
    private String file;
    private List<Plate> plates = new ArrayList<Plate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectraMaxFileInfo(String file) throws IOException {
        this.file = file;
        try {
            this.br = IOUtil.getBufferedReader(file);
            Plate plate = null;
            while ((plate = this.readPlate()) != null) {
                this.plates.add(plate);
            }
        }
        finally {
            if (this.br != null) {
                this.br.close();
            }
        }
    }

    @Override
    public int getColumns() {
        return this.plates.get(0).matrix[0].length;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public float[][] getMatrix(int index) {
        return this.plates.get(index).matrix;
    }

    @Override
    public int getNumberOfPlates() {
        return this.plates.size();
    }

    @Override
    public String getPlateName(int index) {
        return this.plates.get(index).plateName;
    }

    @Override
    public int getRows() {
        return this.plates.get(0).matrix.length;
    }

    private Plate readPlate() throws IOException {
        String[] plateStart = this.readToPlateStart();
        if (plateStart != null) {
            String s;
            String plateName = plateStart[1];
            if (plateName.startsWith("Plate#")) {
                plateName = plateName.substring("Plate#".length());
            }
            String[] header = IOUtil.split(this.br.readLine(), -1);
            boolean hasTime = false;
            if (header[0].indexOf("Time") != -1) {
                hasTime = true;
            }
            String[] dataHeader = IOUtil.split(this.br.readLine(), 0);
            int dataColumns = dataHeader.length - 2;
            float[] array = new float[dataColumns];
            for (int j = 0; j < dataColumns; ++j) {
                String token = dataHeader[j + 2];
                array[j] = "#Low".equals(token) ? Float.NaN : ParserHelper.parseFloatNaN(token);
            }
            ArrayList<float[]> list = new ArrayList<float[]>();
            list.add(array);
            String[] tokens = new String[dataColumns + 2];
            while ((s = this.br.readLine()) != null && !s.trim().equals("")) {
                IOUtil.split(s, tokens, '\t');
                array = new float[dataColumns];
                for (int j = 0; j < dataColumns; ++j) {
                    String token = tokens[j + 2];
                    if ("#Low".equals(token)) {
                        array[j] = Float.NaN;
                        continue;
                    }
                    try {
                        array[j] = ParserHelper.parseFloatNaN(token);
                        continue;
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        throw new RuntimeException("Unable to parse plate " + plateName + " in file " + new File(this.file).getName());
                    }
                }
                list.add(array);
            }
            float[][] matrix = new float[list.size()][];
            int length = matrix.length;
            for (int i = 0; i < length; ++i) {
                matrix[i] = (float[])list.get(i);
            }
            return new Plate(matrix, plateName);
        }
        return null;
    }

    private String[] readToPlateStart() throws IOException {
        String s;
        while ((s = this.br.readLine()) != null) {
            String[] tokens = IOUtil.split(s, -1);
            if (tokens.length < 2 || tokens[1].trim().equals("")) continue;
            return tokens;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        new SpectraMaxFileInfo("C:\\Documents and Settings\\jgould.GPE61-20F\\Desktop\\datafilesandplatemap\\20100803 GFP Reading.txt");
    }

    private static class Plate {
        private float[][] matrix;
        private String plateName;

        public Plate(float[][] matrix, String plateName) {
            this.matrix = matrix;
            this.plateName = plateName;
        }

        public String toString() {
            return "plateName=" + this.plateName;
        }
    }
}

