/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.res;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class ResReader
implements ProjectReader {
    private List<String> fileSuffixes = Collections.unmodifiableList(Arrays.asList("res"));
    private BufferedReader reader;
    private int rows;
    private int columns;
    private boolean keepCalls = false;
    private static final Character A = Character.valueOf('A');
    private static final Character M = Character.valueOf('M');
    private static final Character P = Character.valueOf('P');

    @Override
    public List<String> getFileSuffixes() {
        return this.fileSuffixes;
    }

    @Override
    public String getFormatName() {
        return "res";
    }

    @Override
    public Project read(String file) throws IOException {
        try {
            this.reader = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)), 0x100000);
            RowMajorArray2DDataset dataset = this.readHeader(file);
            this.readData(dataset);
            DefaultProject defaultProject = new DefaultProject(dataset);
            return defaultProject;
        }
        catch (OutOfMemoryError t) {
            this.rows = 0;
            this.columns = 0;
            throw t;
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    public void setKeepCalls(boolean keepCalls) {
        this.keepCalls = keepCalls;
    }

    private String getRowString(int rows) {
        if (rows == 1) {
            return "row";
        }
        return "rows";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readData(RowMajorArray2DDataset dataset) throws IOException, IOException {
        int expectedColumns = 2 * this.columns + 2;
        int rowIndex = 0;
        String[] tokens = new String[expectedColumns];
        boolean nonNullRowDesc = false;
        Vector rowDescVector = dataset.getRowMetadata().get(1);
        int callSeriesIndex = -1;
        if (this.keepCalls) {
            callSeriesIndex = dataset.addSeries("A-P calls", Character.class);
        }
        String s = this.reader.readLine();
        while (true) {
            block16: {
                int tokenIndex;
                block17: {
                    block14: {
                        String desc;
                        block15: {
                            if (s == null) break block14;
                            if (rowIndex < this.rows) break block15;
                            if (!s.trim().equals("")) {
                                int rowsRead = rowIndex + 1;
                                throw new IOException("More data rows than expected. Read " + rowsRead + ", expected " + this.rows + ".");
                            }
                            --rowIndex;
                            break block16;
                        }
                        IOUtil.split(s, tokens, '\t');
                        String string = desc = "".equals(tokens[0]) ? null : new String(tokens[0]);
                        if (desc != null) {
                            rowDescVector.setValue(rowIndex, desc);
                            nonNullRowDesc = true;
                        }
                        String rowName = new String(tokens[1]);
                        dataset.getRowMetadata().setValue(rowIndex, 0, (Object)rowName);
                        tokenIndex = 2;
                        break block17;
                    }
                    if (rowIndex != this.rows) {
                        throw new IOException("Missing data rows. Read " + rowIndex + " " + this.getRowString(rowIndex) + ", expected " + this.rows);
                    }
                    if (!nonNullRowDesc) {
                        dataset.getRowMetadata().remove(1);
                    }
                    return;
                }
                for (int columnIndex = 0; columnIndex < this.columns; ++columnIndex, tokenIndex += 2) {
                    try {
                        float data = ParserHelper.parseFloatNaN(tokens[tokenIndex]);
                        dataset.setValue(rowIndex, columnIndex, data);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("Data at line number " + (rowIndex + 1) + " and column " + columnIndex + " is not a number.");
                    }
                    if (!this.keepCalls) continue;
                    String callString = tokens[tokenIndex + 1];
                    Character call = null;
                    if ("P".equals(callString)) {
                        call = P;
                    } else if ("A".equals(callString)) {
                        call = A;
                    } else if ("M".equals(callString)) {
                        call = M;
                    }
                    dataset.setObjectValue(rowIndex, columnIndex, call, callSeriesIndex);
                }
            }
            s = this.reader.readLine();
            ++rowIndex;
        }
    }

    private RowMajorArray2DDataset readHeader(String file) throws IOException {
        String sampleIdLine = this.reader.readLine();
        String sampleDescriptionsLine = this.reader.readLine();
        String numberOfRowsLine = this.reader.readLine();
        ResHeader header = ResReader.readResHeader(sampleIdLine, numberOfRowsLine);
        this.columns = header.columns.size();
        this.rows = header.rows;
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(IOUtil.getName(file), this.rows, this.columns);
        MetadataUtil.addRowVector(dataset.getRowMetadata(), "Id", String.class);
        MetadataUtil.addRowVector(dataset.getRowMetadata(), "Description", String.class);
        Vector columnNames = MetadataUtil.addRowVector(dataset.getColumnMetadata(), "Id", String.class);
        for (int j = 0; j < this.columns; ++j) {
            columnNames.setValue(j, header.columns.get(j));
        }
        return dataset;
    }

    public static ResHeader readResHeader(String sampleIdLine, String numberOfRowsLine) throws IOException {
        ArrayList<String> sampleNamesList = new ArrayList<String>();
        if (sampleIdLine != null && sampleIdLine.length() > 0) {
            String[] tokens = IOUtil.split(sampleIdLine);
            if (tokens == null || tokens.length == 0 || tokens.length == 1) {
                throw new IOException("Unable to parse line 1");
            }
            String desc = tokens[0];
            String acc = tokens[1];
            int sampleIndex = 2;
            int j = 1;
            int length = tokens.length;
            while (sampleIndex < length) {
                String sampleName = tokens[sampleIndex].trim();
                sampleNamesList.add(sampleName);
                sampleIndex += 2;
                ++j;
            }
            if (sampleIndex - 1 != tokens.length) {
                for (int i = sampleIndex - 2; i < tokens.length; ++i) {
                    sampleNamesList.add(tokens[i]);
                }
                throw new IOException("Line 1 does not contain the correct number of tabs. Column names: " + sampleNamesList);
            }
        } else {
            throw new IOException("Missing column names.");
        }
        int columns = sampleNamesList.size();
        if (columns == 0) {
            throw new IOException("Number of columns must be greater than 0.");
        }
        int rows = 0;
        if (numberOfRowsLine != null && numberOfRowsLine.trim().length() > 0) {
            try {
                rows = Integer.parseInt(numberOfRowsLine.trim());
            }
            catch (NumberFormatException e) {
                throw new IOException("Number of rows missing.");
            }
        } else {
            throw new IOException("Number of rows missing.");
        }
        if (rows <= 0) {
            throw new IOException("Number of rows must be greater than 0.");
        }
        return new ResHeader(rows, sampleNamesList);
    }

    public static class ResHeader {
        public List<String> columns;
        public int rows;

        public ResHeader(int rows, List<String> columns) {
            this.rows = rows;
            this.columns = columns;
        }
    }
}

