/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.stanford;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.DefaultMetadataModel;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class CdtReader
implements ProjectReader {
    private int columns;
    private boolean name_col = false;
    private boolean eweight = false;
    private boolean eorder = false;
    private boolean gweight = false;
    private boolean gorder = false;
    private boolean aid = false;
    private boolean gid_col = false;
    private static final List<String> suffixes = Collections.unmodifiableList(Arrays.asList("pcl", "cdt"));
    private String formatName = "cdt";
    private List<String> arrayIds;
    private List<String> rowNames;
    private ArrayList<float[]> dataList;
    private List<String> geneIdRowVector;
    private List<String> descriptionVector;

    @Override
    public List<String> getFileSuffixes() {
        return suffixes;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project read(String file) throws IOException {
        BufferedReader reader = null;
        this.columns = 0;
        this.geneIdRowVector = null;
        this.descriptionVector = null;
        this.rowNames = null;
        this.dataList = null;
        this.name_col = false;
        this.eweight = false;
        this.eorder = false;
        this.gweight = false;
        this.gorder = false;
        this.aid = false;
        this.gid_col = false;
        this.arrayIds = null;
        this.rowNames = new ArrayList<String>();
        try {
            int i;
            int rows;
            int j;
            reader = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)), 0x100000);
            this.dataList = new ArrayList();
            String line = reader.readLine();
            StringTokenizer tokens = new StringTokenizer(line, "\t", true);
            String token = tokens.nextToken();
            if (token.equalsIgnoreCase("GID")) {
                this.gid_col = true;
                token = tokens.nextToken();
            }
            token = tokens.nextToken();
            int count = 0;
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (token.equalsIgnoreCase("name")) {
                    this.name_col = true;
                    token = tokens.nextToken();
                } else if (token.equalsIgnoreCase("gweight")) {
                    this.gweight = true;
                    token = tokens.nextToken();
                } else if (token.equalsIgnoreCase("gorder")) {
                    this.gorder = true;
                    token = tokens.nextToken();
                } else {
                    ++count;
                }
                if (token.equals("\t") || !tokens.hasMoreTokens()) continue;
                token = tokens.nextToken();
            }
            tokens = new StringTokenizer(line, "\t", true);
            if (this.hasGid()) {
                token = tokens.nextToken();
                token = tokens.nextToken();
            }
            token = tokens.nextToken();
            token = tokens.nextToken();
            if (this.hasColumnName()) {
                token = tokens.nextToken();
                token = tokens.nextToken();
            }
            if (this.hasGweight()) {
                token = tokens.nextToken();
                token = tokens.nextToken();
            }
            if (this.hasGorder()) {
                token = tokens.nextToken();
                token = tokens.nextToken();
            }
            count = 0;
            ArrayList<String> columnNames = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (!token.equals("\t")) {
                    columnNames.add(token);
                    if (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                    }
                }
                ++count;
            }
            this.columns = columnNames.size();
            if (count != this.columns) {
                throw new IOException("Unexpected number of columns. Got " + count + ", expected " + this.columns + ".");
            }
            DefaultMetadataModel columnMetaData = new DefaultMetadataModel(this.columns);
            Vector columnIds = columnMetaData.add("Id", String.class);
            int ncols = columnNames.size();
            for (j = 0; j < ncols; ++j) {
                columnIds.setValue(j, columnNames.get(j));
            }
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("AID")) {
                    this.aid = true;
                    this.setArrayIds(line);
                    continue;
                }
                if (line.startsWith("EWEIGHT")) {
                    this.eweight = true;
                    continue;
                }
                if (line.startsWith("EORDER")) {
                    this.eorder = true;
                    continue;
                }
                if (this.hasGid()) {
                    this.geneIdRowVector = new ArrayList<String>();
                }
                this.descriptionVector = new ArrayList<String>();
                if (this.aid) {
                    columnMetaData.add("array id", String.class);
                    for (j = 0; j < this.columns; ++j) {
                        columnMetaData.setValue(j, "array id", (Object)this.arrayIds.get(j));
                    }
                }
                do {
                    if ((line = line.trim()).equals("")) continue;
                    this.parseLine(line);
                } while ((line = reader.readLine()) != null);
            }
            float[][] array = new float[this.dataList.size()][];
            int size = this.dataList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                array[i2] = this.dataList.get(i2);
            }
            DefaultMetadataModel rowMetadata = new DefaultMetadataModel(array.length);
            Vector rowIds = rowMetadata.add("Id", String.class);
            int rows2 = array.length;
            for (int i3 = 0; i3 < rows2; ++i3) {
                rowIds.setValue(i3, this.rowNames.get(i3));
            }
            if (this.geneIdRowVector != null) {
                rowMetadata.add("gene id", String.class);
                int metadataColumnIndex = rowMetadata.getColumnIndex("gene id");
                rowMetadata.get(metadataColumnIndex).setProperty("Text Visible", false);
                rows = array.length;
                for (i = 0; i < rows; ++i) {
                    rowMetadata.setValue(i, metadataColumnIndex, (Object)this.geneIdRowVector.get(i));
                }
            }
            if (this.descriptionVector != null) {
                rowMetadata.add("Description", String.class);
                int columnIndex = rowMetadata.getColumnIndex("Description");
                rows = array.length;
                for (i = 0; i < rows; ++i) {
                    rowMetadata.setValue(i, columnIndex, (Object)this.descriptionVector.get(i));
                }
            }
            RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(IOUtil.getName(file), array);
            dataset.setRowMetadata(rowMetadata);
            dataset.setColumnMetadata(columnMetaData);
            DefaultProject defaultProject = new DefaultProject(dataset);
            return defaultProject;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private boolean hasColumnName() {
        return this.name_col;
    }

    private boolean hasGid() {
        return this.gid_col;
    }

    private boolean hasGorder() {
        return this.gorder;
    }

    private boolean hasGweight() {
        return this.gweight;
    }

    private void parseLine(String line) throws IOException {
        StringTokenizer tokens = new StringTokenizer(line, "\t", true);
        String token = null;
        if (tokens.hasMoreTokens()) {
            if (this.gid_col) {
                token = tokens.nextToken();
                this.geneIdRowVector.add(token != null ? new String(token) : null);
                if (!token.equals("\t") && tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                }
            }
            this.rowNames.add(new String(tokens.nextToken()));
            token = tokens.nextToken();
            if (this.hasColumnName() && !(token = tokens.nextToken()).equals("\t")) {
                this.descriptionVector.add(token != null ? new String(token) : null);
                if (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                }
            }
            if (this.hasGweight() && !(token = tokens.nextToken()).equals("\t") && tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
            if (this.hasGorder() && !(token = tokens.nextToken()).equals("\t") && tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        float[] array = new float[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            array[i] = Float.NaN;
            if (!tokens.hasMoreTokens()) continue;
            String f = tokens.nextToken();
            if (!f.equals("\t")) {
                float value;
                try {
                    value = ParserHelper.parseFloatNaN(f);
                }
                catch (NumberFormatException exc) {
                    value = Float.NaN;
                }
                array[i] = value;
                if (!tokens.hasMoreTokens()) continue;
                token = tokens.nextToken();
                continue;
            }
            array[i] = Float.NaN;
        }
        this.dataList.add(array);
    }

    private void setArrayIds(String line) {
        StringTokenizer tokens = new StringTokenizer(line, "\t", true);
        String token = tokens.nextToken();
        token = tokens.nextToken();
        if (this.hasGid()) {
            token = tokens.nextToken();
        }
        if (this.name_col) {
            token = tokens.nextToken();
        }
        if (this.gweight) {
            token = tokens.nextToken();
        }
        if (this.gorder) {
            token = tokens.nextToken();
        }
        int i = 0;
        this.arrayIds = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token.startsWith("ARRY") && token.endsWith("X")) {
                try {
                    this.arrayIds.add(token);
                    if (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }
}

