/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.persistence;

import com.google.common.io.Files;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.broadinstitute.genee.application.HistoryAuditTrail;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.persistence.HeatMapColorSchemePersistence;
import org.broadinstitute.genee.io.persistence.HeatMapDisplayPersistence;
import org.broadinstitute.genee.io.persistence.VectorPersistence;
import org.broadinstitute.genee.matrix.MetadataModel;

public class GENEEOptions {
    private HistoryAuditTrail auditTrail;
    private HeatMapColorSchemePersistence colorScheme;
    private VectorPersistence[] columnMetadata;
    private HeatMapDisplayPersistence display;
    private VectorPersistence[] rowMetadata;

    public GENEEOptions() {
    }

    public GENEEOptions(ProjectGENEEResultTreeNode node) {
        Project project = node.getProject();
        this.columnMetadata = GENEEOptions.createMetadataColumnPersistence(project.getOriginalDataset().getColumnMetadata());
        this.rowMetadata = GENEEOptions.createMetadataColumnPersistence(project.getOriginalDataset().getRowMetadata());
        if (node.getDisplayInfo().getComponent() instanceof HeatMapPanel) {
            this.colorScheme = new HeatMapColorSchemePersistence(((HeatMapPanel)node.getDisplayInfo().getComponent()).getElementPanel().getColorScheme());
            this.display = new HeatMapDisplayPersistence((HeatMapPanel)node.getDisplayInfo().getComponent());
        }
        this.auditTrail = node.getAuditTrail();
    }

    public HistoryAuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    public static void configureHeatMap(HeatMapPanel panel, GENEEOptions options) {
        if (options.colorScheme != null) {
            HeatMapColorSchemePersistence.configure(panel.getColorScheme(), options.colorScheme);
        }
        if (options.display != null) {
            HeatMapDisplayPersistence.configure(panel, options.display);
        }
    }

    public static void configureMetadata(Project p, GENEEOptions options) {
        if (options.rowMetadata != null) {
            GENEEOptions.configure(p.getOriginalDataset().getRowMetadata(), options.rowMetadata);
        }
        if (options.columnMetadata != null) {
            GENEEOptions.configure(p.getOriginalDataset().getColumnMetadata(), options.columnMetadata);
        }
    }

    public static GENEEOptions create(File file) {
        try {
            return GENEEOptions.create(Files.toString((File)file, (Charset)Charset.defaultCharset()));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Unable to open options");
            return null;
        }
    }

    public static GENEEOptions create(String text) {
        try {
            return (GENEEOptions)GENEEOptions.getXStream().fromXML(text);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Unable to open options");
            return null;
        }
    }

    public static void save(ProjectGENEEResultTreeNode node, File file) {
        try {
            Files.write((CharSequence)GENEEOptions.getXStream().toXML((Object)new GENEEOptions(node)), (File)file, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String toString(ProjectGENEEResultTreeNode node) {
        return GENEEOptions.getXStream().toXML((Object)new GENEEOptions(node));
    }

    private static void configure(MetadataModel metadata, VectorPersistence[] options) {
        for (VectorPersistence persistence : options) {
            int index = metadata.getColumnIndex(persistence.getName());
            if (index == -1) continue;
            VectorPersistence.configure(metadata.get(index), persistence);
        }
    }

    private static VectorPersistence[] createMetadataColumnPersistence(MetadataModel metadata) {
        VectorPersistence[] metadataColumns = new VectorPersistence[metadata.getMetadataCount()];
        int size = metadata.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            metadataColumns[i] = new VectorPersistence(metadata.get(i));
        }
        return metadataColumns;
    }

    private static XStream getXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        return xstream;
    }
}

