/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.persistence;

import java.awt.Color;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;

public class HeatMapColorSchemePersistence {
    private float customGlobalMax = Float.NaN;
    private float customGlobalMin = Float.NaN;
    private int maxGlobalScalingMode;
    private int minGlobalScalingMode;
    private boolean relative;
    private float rowNormalizedMax = 3.0f;
    private float rowNormalizedMin = -3.0f;
    private int rowScalingMode;
    private Color missingColor = Color.LIGHT_GRAY;
    private boolean logScale;
    private Color[] colors;
    private float[] fractions;

    public HeatMapColorSchemePersistence() {
    }

    public HeatMapColorSchemePersistence(HeatMapColorScheme colorScheme) {
        this.customGlobalMax = colorScheme.getCustomGlobalMax();
        this.customGlobalMin = colorScheme.getCustomGlobalMin();
        this.maxGlobalScalingMode = colorScheme.getMaxGlobalScalingMode();
        this.minGlobalScalingMode = colorScheme.getMinGlobalScalingMode();
        this.relative = colorScheme.isRelative();
        this.rowNormalizedMax = colorScheme.getRowNormalizedMax();
        this.rowNormalizedMin = colorScheme.getRowNormalizedMin();
        this.rowScalingMode = colorScheme.getRowScalingMode();
        this.missingColor = colorScheme.getMissingColor();
        this.logScale = colorScheme.isLogScale();
        this.colors = colorScheme.getColors();
        this.fractions = colorScheme.getFractions();
    }

    public static void configure(HeatMapColorScheme colorScheme, HeatMapColorSchemePersistence persistence) {
        if (persistence != null) {
            colorScheme.setGlobalMaxMode(persistence.maxGlobalScalingMode, persistence.customGlobalMax);
            colorScheme.setGlobalMinMode(persistence.minGlobalScalingMode, persistence.customGlobalMin);
            colorScheme.setRelative(persistence.relative);
            colorScheme.setRowNormalizedMax(persistence.rowNormalizedMax);
            colorScheme.setRowNormalizedMin(persistence.rowNormalizedMin);
            colorScheme.setRowScalingMode(persistence.rowScalingMode);
            colorScheme.setMissingColor(persistence.missingColor);
            colorScheme.setLogScale(persistence.logScale);
            colorScheme.setColors(persistence.colors, persistence.fractions);
        }
    }
}

