/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.persistence;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.ExternalFileGENEETreeNode;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.TreeNavigator;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.BreadthFirstEnumeration;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DisplayInfo;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.gctx.GctxProjectWriter;
import org.broadinstitute.genee.io.persistence.GENEEOptions;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;

public class SessionSaver {
    static final String SETTINGS_EXTENSION = ".xml";

    private SessionSaver() {
    }

    public static List<GENEEFolderNode> getNewSessions() {
        TreeNavigator nav = Application.getNavigator();
        if (nav == null) {
            return Collections.emptyList();
        }
        TreeNode rootNode = nav.getRoot();
        Enumeration<? extends TreeNode> children = rootNode.children();
        ArrayList<GENEEFolderNode> list = new ArrayList<GENEEFolderNode>();
        while (children.hasMoreElements()) {
            GENEEFolderNode rootOperationNode = (GENEEFolderNode)children.nextElement();
            if (rootOperationNode.getSessionName() != null) continue;
            list.add(rootOperationNode);
        }
        return list;
    }

    public static File getRootSessionsDir() {
        return new File(Application.getGENEEDir(), "Sessions");
    }

    public static File[] getSessionDirs() {
        File sessionBaseDir = SessionSaver.getRootSessionsDir();
        File[] childDirs = sessionBaseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        return childDirs == null ? new File[]{} : childDirs;
    }

    public static GENEEFolderNode open(File dir) throws IOException {
        GENEEFolderNode node = SessionSaver.open(dir.getParentFile(), dir.getName());
        node.setSessionName(dir.getName());
        return node;
    }

    public static GENEEFolderNode[] open(Set<String> sessions) throws IOException {
        File[] sessionDirs = SessionSaver.getSessionDirs();
        ArrayList<GENEEFolderNode> results = new ArrayList<GENEEFolderNode>();
        File sessionBaseDir = new File(Application.getGENEEDir(), "Sessions");
        for (File sessionFile : sessionDirs) {
            if (!sessions.contains(sessionFile.getName())) continue;
            GENEEFolderNode node = SessionSaver.open(sessionBaseDir, sessionFile.getName());
            node.setSessionName(sessionFile.getName());
            results.add(node);
        }
        return results.toArray(new GENEEFolderNode[0]);
    }

    public static void save(TreeNode rootNode, Map<GENEEFolderNode, String> nodeToSessionName) throws IOException {
        File sessionBaseDir = new File(Application.getGENEEDir(), "Sessions");
        if (!sessionBaseDir.exists()) {
            sessionBaseDir.mkdirs();
        }
        Enumeration<? extends TreeNode> children = rootNode.children();
        boolean permissionsChecked = false;
        while (children.hasMoreElements()) {
            GENEEFolderNode rootOperationNode = (GENEEFolderNode)children.nextElement();
            if (rootOperationNode.getSessionName() != null) {
                if (!permissionsChecked) {
                    if (!sessionBaseDir.canWrite()) {
                        UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "You do not have permission to write to " + IOUtil.getPath(sessionBaseDir) + ".");
                        throw new IOException();
                    }
                    permissionsChecked = true;
                }
                SessionSaver.saveRoot(rootOperationNode, rootOperationNode.getSessionName());
                continue;
            }
            if (rootOperationNode.getSessionName() != null) continue;
            String newSessionName = nodeToSessionName.get(rootOperationNode);
            if (!permissionsChecked) {
                if (!sessionBaseDir.canWrite()) {
                    UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "You do not have permission to write to " + IOUtil.getPath(sessionBaseDir) + ".");
                    throw new IOException();
                }
                permissionsChecked = true;
            }
            if (newSessionName == null) continue;
            SessionSaver.saveRoot(rootOperationNode, newSessionName);
        }
    }

    public static Map<GENEEFolderNode, String> showGui() {
        List<GENEEFolderNode> newSessions = SessionSaver.getNewSessions();
        FormBuilder sessionNameForm = new FormBuilder();
        JTextField[] textFields = new JTextField[newSessions.size()];
        for (int i = 0; i < newSessions.size(); ++i) {
            sessionNameForm.nextRow();
            String name = newSessions.get(i).toString();
            sessionNameForm.addLabel(name + ":");
            textFields[i] = new JTextField(14);
            sessionNameForm.add(textFields[i]);
        }
        if (UIUtil.showOkCancelDialog(UIUtil.getCurrentFrame(), sessionNameForm.getPanel(), "Save Session")) {
            HashMap<GENEEFolderNode, String> nodeToSessionName = new HashMap<GENEEFolderNode, String>();
            for (int i = 0; i < newSessions.size(); ++i) {
                String name = textFields[i].getText();
                if (name.equals("")) {
                    name = null;
                }
                nodeToSessionName.put(newSessions.get(i), name);
            }
            return nodeToSessionName;
        }
        return null;
    }

    private static File getDirectoryForFolderNode(GENEEFolderNode node, File sessionDir) {
        int startLevel;
        TreeNode tmp;
        TreeNode[] treeNodes = node.getPath();
        if (treeNodes.length > 1 && (tmp = treeNodes[treeNodes.length - 2]) instanceof GENEEFolderNode) {
            return new File(((GENEEFolderNode)tmp).getFile(), node.toString());
        }
        File file = sessionDir;
        for (int i = startLevel = 1; i < treeNodes.length; ++i) {
            file = new File(file, treeNodes[i].toString());
        }
        return file;
    }

    private static GENEEFolderNode open(File sessionBaseDir, String sessionName) throws IOException {
        File sessionDir = new File(sessionBaseDir, sessionName);
        LinkedList<File> q = new LinkedList<File>();
        q.add(sessionDir);
        GENEEFolderNode rootNode = null;
        LinkedHashMap<File, GENEEFolderNode> fileToFolderNode = new LinkedHashMap<File, GENEEFolderNode>();
        while (!q.isEmpty()) {
            File[] childDirs;
            File folder = (File)q.removeFirst();
            GENEEFolderNode newFolderNode = new GENEEFolderNode(IOUtil.getBaseFileName(folder.getName()), null, new MutableTreeNode[0]);
            newFolderNode.setFile(folder);
            if (rootNode == null) {
                rootNode = newFolderNode;
            }
            fileToFolderNode.put(folder, newFolderNode);
            File[] childFiles = folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName().toLowerCase();
                    return !pathname.isDirectory() && !name.endsWith("~") && !name.endsWith(".css") && !name.startsWith(".");
                }
            });
            if (childFiles != null) {
                for (File gctxFile : childFiles) {
                    DefaultMutableTreeNode childNode;
                    File optionsFile = new File(gctxFile.getParentFile(), "." + IOUtil.getBaseFileName(gctxFile) + SETTINGS_EXTENSION);
                    GENEEOptions geneeOptions = null;
                    if (optionsFile.exists()) {
                        geneeOptions = GENEEOptions.create(optionsFile);
                    }
                    Project project = null;
                    try {
                        project = ProjectIO.readProject(IOUtil.getPath(gctxFile));
                    }
                    catch (Exception x) {
                        System.err.println("Unable to read " + gctxFile);
                    }
                    if (project != null) {
                        if (geneeOptions != null) {
                            project.getOriginalDataset().setProperty("genee.options", geneeOptions);
                        }
                        HeatMapPanel panel = new HeatMapPanel(project);
                        childNode = new ProjectGENEEResultTreeNode(project, new DisplayInfo(panel), null);
                    } else {
                        childNode = new ExternalFileGENEETreeNode();
                    }
                    childNode.setFile(gctxFile);
                    newFolderNode.add(childNode);
                }
            }
            if ((childDirs = folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !pathname.getName().startsWith(".");
                }
            })) == null) continue;
            for (File child : childDirs) {
                q.addFirst(child);
            }
        }
        for (File file : fileToFolderNode.keySet()) {
            GENEEFolderNode parentFolder = (GENEEFolderNode)fileToFolderNode.get(file.getParentFile());
            if (parentFolder == null) continue;
            parentFolder.add((MutableTreeNode)fileToFolderNode.get(file));
        }
        return rootNode;
    }

    private static void saveNode(DefaultMutableTreeNode node, File sessionDir) throws IOException {
        if (node instanceof ViewableGENEETreeNode) {
            ProjectGENEEResultTreeNode projectNode = (ProjectGENEEResultTreeNode)node;
            if (!projectNode.isOpened() && projectNode.getFile() != null) {
                return;
            }
            MutableTreeNode folderNode = AbstractInputAction.getFolderNode(node);
            if (folderNode instanceof GENEETreeNode) {
                String name = IOUtil.getBaseFileName(projectNode.getProject().getOriginalDataset().getName());
                File savedSesionFile = new File(((GENEETreeNode)folderNode).getFile(), name + ".gctx");
                if (!savedSesionFile.exists()) {
                    GctxProjectWriter writer = new GctxProjectWriter();
                    File tmpFile = File.createTempFile("sess", ".gctx");
                    writer.write(projectNode.getProject(), tmpFile.getCanonicalPath());
                    tmpFile.renameTo(savedSesionFile);
                }
            }
        }
    }

    private static void saveRoot(GENEEFolderNode rootOperationNode, String sessionName) throws IOException {
        DefaultMutableTreeNode child;
        System.out.println("Saving root node " + rootOperationNode);
        File sessionBaseDir = new File(Application.getGENEEDir(), "Sessions");
        File sessionDir = new File(sessionBaseDir, sessionName);
        if (!sessionDir.exists()) {
            sessionDir.mkdirs();
        }
        if (!sessionDir.isDirectory()) {
            throw new IOException("Unable to save session.");
        }
        BreadthFirstEnumeration bfs = new BreadthFirstEnumeration(rootOperationNode);
        while (bfs.hasMoreElements()) {
            File dir;
            child = (DefaultMutableTreeNode)bfs.nextElement();
            if (!(child instanceof GENEEFolderNode)) continue;
            GENEEFolderNode folderNode = (GENEEFolderNode)child;
            if (folderNode.getFile() != null) {
                dir = folderNode.getFile();
                continue;
            }
            dir = SessionSaver.getDirectoryForFolderNode(folderNode, sessionDir);
            int counter = 1;
            while (dir.exists()) {
                dir = new File(dir.getParentFile(), IOUtil.getBaseFileName(dir.getName()) + "." + counter);
                ++counter;
            }
            dir.mkdirs();
            folderNode.setFile(dir);
        }
        bfs = new BreadthFirstEnumeration(rootOperationNode);
        while (bfs.hasMoreElements()) {
            child = (DefaultMutableTreeNode)bfs.nextElement();
            SessionSaver.saveNode(child, sessionDir);
        }
        File[] files = sessionDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().startsWith(".");
            }
        });
        if (files == null || files.length == 0) {
            sessionDir.delete();
        }
    }
}

