/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex;

import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.TroveFloatList;
import org.broadinstitute.genee.matrix.Vector;

public abstract class AbstractPlateOperation {
    private CollapseMethodOption collapseMethod;
    private int trimmedMeanS;
    private int trimmedMeanL;
    private Dataset dataset;
    private String metadataFieldName;
    private Set<Object> fieldValues;
    private Map<Object, TIntArrayList> plateToRowIndicesMap;
    private String operationName;

    public AbstractPlateOperation(String operationName, Dataset dataset, String metadataFieldName, Set<Object> fieldValues) {
        this.operationName = operationName;
        this.dataset = dataset;
        this.metadataFieldName = metadataFieldName;
        this.fieldValues = fieldValues;
    }

    public Dataset execute() {
        Vector vector = this.dataset.getRowMetadata().get(this.metadataFieldName);
        if (vector == null) {
            throw new IllegalArgumentException(this.metadataFieldName + " field not found for " + this.operationName + " operation. Annotations available are: " + MetadataUtil.getNames(this.dataset.getRowMetadata()));
        }
        RowMajorArray2DDataset operationDataset = new RowMajorArray2DDataset(this.operationName, this.plateToRowIndicesMap.size(), this.dataset.getColumnCount());
        Vector plateVector = MetadataUtil.addRowVector(operationDataset.getRowMetadata(), this.metadataFieldName, vector.getColumnClass());
        int plateIndex = 0;
        for (Object currentPlate : this.plateToRowIndicesMap.keySet()) {
            plateVector.setValue(plateIndex, currentPlate);
            TIntArrayList rowIndices = this.plateToRowIndicesMap.get(currentPlate);
            boolean found = false;
            for (int j = 0; j < this.dataset.getColumnCount(); ++j) {
                TFloatArrayList matches = new TFloatArrayList();
                int rows = rowIndices.size();
                for (int i = 0; i < rows; ++i) {
                    int rowIndex = rowIndices.getQuick(i);
                    if (!this.fieldValues.contains(vector.getValue(rowIndex))) continue;
                    float value = this.dataset.getValue(rowIndex, j);
                    found = true;
                    if (Float.isNaN(value)) continue;
                    matches.add(value);
                }
                if (!found) {
                    throw new RuntimeException(this.metadataFieldName + " field name not found on " + currentPlate + ".  Looking for " + this.fieldValues);
                }
                float matchesValue = 0.0f;
                if (matches.size() == 0) {
                    matchesValue = 0.0f;
                    System.out.println("Background is zero for plate " + currentPlate + " in column " + ToStringUtil.toString(this.dataset.getColumnMetadata(), j) + ".");
                } else {
                    matchesValue = this.collapseMethod == CollapseMethodOption.MEAN ? FloatListStatUtils.mean(new TroveFloatList(matches)) : (this.collapseMethod == CollapseMethodOption.MEDIAN ? FloatListStatUtils.median(new TroveFloatList(matches)) : FloatListStatUtils.trimmedMean(new TroveFloatList(matches), this.trimmedMeanS, this.trimmedMeanL));
                }
                operationDataset.setValue(plateIndex, j, matchesValue);
                int nrows = rowIndices.size();
                for (int i = 0; i < nrows; ++i) {
                    int index = rowIndices.getQuick(i);
                    float newValue = this.dataset.getValue(index, j) - matchesValue;
                    this.dataset.setValue(index, j, newValue);
                }
            }
            ++plateIndex;
        }
        return operationDataset;
    }

    protected abstract float transform(float var1, float var2);

    public void setCollapseMethod(CollapseMethodOption backgroundSubtractionCollapseMethod) {
        this.collapseMethod = backgroundSubtractionCollapseMethod;
    }

    public void setPlateToRowIndicesMap(Map<Object, TIntArrayList> plateToRowIndicesMap) {
        this.plateToRowIndicesMap = plateToRowIndicesMap;
    }

    public void setTrimmedMeanL(int subtractBackgroundTrimmedMeanL) {
        this.trimmedMeanL = subtractBackgroundTrimmedMeanL;
    }

    public void setTrimmedMeanS(int subtractBackgroundTrimmedMeanS) {
        this.trimmedMeanS = subtractBackgroundTrimmedMeanS;
    }

    public String toString() {
        String bg = "Subtracted " + (Object)((Object)this.collapseMethod) + " of " + this.metadataFieldName;
        if (this.collapseMethod == CollapseMethodOption.TRIMMED_MEAN) {
            bg = bg + " s=" + this.trimmedMeanS + ", l=" + this.trimmedMeanL;
        }
        return bg;
    }
}

