/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex;

import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.heatmap.DefaultToolTipProvider;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class CollapsedToolTipProvider
extends DefaultToolTipProvider {
    private List<RowMajorArray2DDataset> datasetProcessingSteps;
    private Map<Identifier, TIntArrayList> replicateMap;
    private String[] collapseToFields;

    public CollapsedToolTipProvider(List<RowMajorArray2DDataset> datasetProcessingSteps, Map<Identifier, TIntArrayList> replicateMap, String[] collapseToFields) {
        this.datasetProcessingSteps = datasetProcessingSteps;
        this.replicateMap = replicateMap;
        this.collapseToFields = collapseToFields;
    }

    @Override
    protected void update(Dataset dataset, int row, int column, StringBuilder buf) {
        Object[] array = new Object[this.collapseToFields.length];
        for (int i = 0; i < this.collapseToFields.length; ++i) {
            array[i] = dataset.getRowMetadata().get(this.collapseToFields[i]).getValue(row);
        }
        TIntArrayList rowIndices = this.replicateMap.get(new Identifier<Object>(array));
        buf.append("<br><table border=1><th>Step<th colspan=" + rowIndices.size() + ">Values");
        for (int i = 0; i < this.datasetProcessingSteps.size(); ++i) {
            Dataset previousDataset = this.datasetProcessingSteps.get(i);
            buf.append("<tr><td>");
            String name = i == 0 ? "Original data" : previousDataset.getName();
            buf.append(i + 1 + ". " + name);
            for (int j = 0; j < rowIndices.size(); ++j) {
                buf.append("<td>");
                int index = rowIndices.getQuick(j);
                if (previousDataset.getValue(index, column) < 0.0f) {
                    buf.append("<font color=red>");
                    buf.append(Formatter.format(previousDataset.getValue(index, column)));
                    buf.append("</font>");
                    continue;
                }
                buf.append(Formatter.format(previousDataset.getValue(index, column)));
            }
        }
        buf.append("</table>");
    }
}

