/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.luminex.LuminexCsvParser;
import org.broadinstitute.genee.io.matrix.dchip.AbstractSampleInfoFile;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.PlateUtil;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class LuminexImporter {
    public static HashMap<Object, TIntArrayList> createPlateNameToRowIndices(String plateFieldName, Dataset dataset) {
        LinkedHashMap<Object, TIntArrayList> plateNameToRowIndices = new LinkedHashMap<Object, TIntArrayList>();
        MetadataModel md = dataset.getRowMetadata();
        if (dataset.getRowMetadata().getColumnIndex(plateFieldName) != -1) {
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                Object plate = md.getValue(i, plateFieldName);
                TIntArrayList indices = (TIntArrayList)((HashMap)plateNameToRowIndices).get(plate);
                if (indices == null) {
                    indices = new TIntArrayList();
                    plateNameToRowIndices.put(plate, indices);
                }
                indices.add(i);
            }
        } else {
            System.out.println("Plate metadata field " + plateFieldName + " not found.");
            TIntArrayList indices = new TIntArrayList();
            plateNameToRowIndices.put("", indices);
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                indices.add(i);
            }
        }
        return plateNameToRowIndices;
    }

    public static void showLuminexImportUI(final String[] csvFiles) {
        FormBuilder builder = new FormBuilder();
        builder.nextRow();
        boolean oneCsvFile = csvFiles.length == 1;
        builder.addLabel("Bead Mapping " + (oneCsvFile ? "File:" : "File(s):"));
        final FileInputParameter beadMappingFilesInputPanel = new FileInputParameter(null, oneCsvFile ? FileInputParameter.OPEN_FILE : FileInputParameter.OPEN_FILES);
        builder.add(beadMappingFilesInputPanel);
        builder.nextRow();
        builder.nextRow();
        builder.addLabel("Well Mapping " + (oneCsvFile ? "File:" : "File(s):"));
        final FileInputParameter locationFilesInput = new FileInputParameter(null, oneCsvFile ? FileInputParameter.OPEN_FILE : FileInputParameter.OPEN_FILES);
        builder.add(locationFilesInput);
        JRadioButton beadsOnColumns = new JRadioButton("columns");
        final JRadioButton beadsOnRows = new JRadioButton("rows", true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(beadsOnColumns);
        bg.add(beadsOnRows);
        builder.nextRow();
        builder.addLabel("Place beads on heat map:");
        builder.add(beadsOnColumns);
        builder.nextSmallRow();
        builder.add(beadsOnRows);
        builder.nextRow();
        builder.addLabel("Data type:");
        final JComboBox dataTypeField = UIUtil.createComboBox();
        dataTypeField.addItem("%CV");
        dataTypeField.addItem("Count");
        dataTypeField.addItem("Mean");
        dataTypeField.addItem("Median");
        dataTypeField.addItem("Peak");
        dataTypeField.addItem("Std Dev");
        dataTypeField.addItem("Trimmed Count");
        dataTypeField.addItem("Trimmed Mean");
        dataTypeField.addItem("Trimmed % CV of Microspheres");
        dataTypeField.addItem("Trimmed Peak");
        dataTypeField.addItem("Trimmed Standard Deviation");
        dataTypeField.setSelectedItem("Median");
        builder.add(dataTypeField);
        builder.nextRow();
        final GENEEWindow importCsvDialog = Application.createDialog("Import Luminex CSV Files");
        importCsvDialog.getContentPane().add(builder.getPanel());
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                importCsvDialog.dispose();
                final File[] inputBeadMappingFiles = beadMappingFilesInputPanel.getFiles();
                String dataType = (String)dataTypeField.getSelectedItem();
                boolean analytesAreGenes = beadsOnRows.isSelected();
                File[] inputLocationMappingFiles = locationFilesInput.getFiles();
                Object[] selectedBeadMappingFiles = null;
                if (inputBeadMappingFiles.length > 0) {
                    selectedBeadMappingFiles = new File[csvFiles.length];
                    Arrays.fill(selectedBeadMappingFiles, inputBeadMappingFiles[0]);
                }
                Object[] selectedLocationMappingFiles = null;
                if (inputLocationMappingFiles.length > 0) {
                    selectedLocationMappingFiles = new File[csvFiles.length];
                    Arrays.fill(selectedLocationMappingFiles, inputLocationMappingFiles[0]);
                }
                if (inputBeadMappingFiles.length > 1 || inputLocationMappingFiles.length > 1) {
                    int i;
                    JPanel panel = new JPanel((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(3), UIUtil.createRowStringForFormLayout(csvFiles.length + 2)));
                    CellConstraints cc = new CellConstraints();
                    UIUtil.setDialogBorder(panel);
                    JLabel l = new JLabel("CSV File");
                    l.setFont(l.getFont().deriveFont(1));
                    panel.add((Component)l, cc.xy(1, 1));
                    JComboBox[] beadMappingFileComboBoxes = new JComboBox[csvFiles.length];
                    JComboBox[] locationMappingFileComboBoxes = new JComboBox[csvFiles.length];
                    Object[] beadMappingFileNames = null;
                    if (inputBeadMappingFiles.length > 1) {
                        beadMappingFileNames = new String[inputBeadMappingFiles.length];
                        for (int i2 = 0; i2 < inputBeadMappingFiles.length; ++i2) {
                            beadMappingFileNames[i2] = inputBeadMappingFiles[i2].getName();
                        }
                        l = new JLabel("Bead Mapping File");
                        l.setFont(l.getFont().deriveFont(1));
                        panel.add((Component)l, cc.xy(3, 1));
                    }
                    Object[] locationMappingFileNames = null;
                    if (inputLocationMappingFiles.length > 1) {
                        locationMappingFileNames = new String[inputLocationMappingFiles.length];
                        for (i = 0; i < inputLocationMappingFiles.length; ++i) {
                            locationMappingFileNames[i] = inputLocationMappingFiles[i].getName();
                        }
                        l = new JLabel("Location Mapping File");
                        l.setFont(l.getFont().deriveFont(1));
                        panel.add((Component)l, cc.xy(5, 1));
                    }
                    i = 0;
                    int row = 3;
                    while (i < csvFiles.length) {
                        panel.add((Component)new JLabel(new File(csvFiles[i]).getName()), cc.xy(1, row));
                        if (inputBeadMappingFiles.length > 1) {
                            JComboBox beadMappingComboBox = UIUtil.createComboBox(beadMappingFileNames);
                            panel.add((Component)beadMappingComboBox, cc.xy(3, row));
                            beadMappingFileComboBoxes[i] = beadMappingComboBox;
                        }
                        if (inputLocationMappingFiles.length > 1) {
                            JComboBox locationMappingComboBox = UIUtil.createComboBox(locationMappingFileNames);
                            panel.add((Component)locationMappingComboBox, cc.xy(5, row));
                            locationMappingFileComboBoxes[i] = locationMappingComboBox;
                        }
                        ++i;
                        row += 2;
                    }
                    JScrollPane sp = UIUtil.createNoBorderScrollPane(panel);
                    final GENEEWindow tmp = Application.getWindowManager().createInputWindow("", null);
                    ((Dialog)((Object)tmp)).setModal(true);
                    tmp.getContentPane().add(sp);
                    JButton okButton = new JButton("OK");
                    tmp.getRootPane().setDefaultButton(okButton);
                    JButton cancelButton = new JButton("Cancel");
                    tmp.getContentPane().add((Component)UIUtil.buildOKCancelBar(okButton, cancelButton), "South");
                    Object[] _selectedBeadMappingFiles = selectedBeadMappingFiles;
                    Object[] _selectedLocationMappingFiles = selectedLocationMappingFiles;
                    okButton.addActionListener(new ActionListener((File[])_selectedBeadMappingFiles, beadMappingFileComboBoxes, inputLocationMappingFiles, (File[])_selectedLocationMappingFiles, locationMappingFileComboBoxes, analytesAreGenes, dataType){
                        final /* synthetic */ File[] val$_selectedBeadMappingFiles;
                        final /* synthetic */ JComboBox[] val$beadMappingFileComboBoxes;
                        final /* synthetic */ File[] val$inputLocationMappingFiles;
                        final /* synthetic */ File[] val$_selectedLocationMappingFiles;
                        final /* synthetic */ JComboBox[] val$locationMappingFileComboBoxes;
                        final /* synthetic */ boolean val$analytesAreGenes;
                        final /* synthetic */ String val$dataType;
                        {
                            this.val$_selectedBeadMappingFiles = fileArray2;
                            this.val$beadMappingFileComboBoxes = jComboBoxArray;
                            this.val$inputLocationMappingFiles = fileArray3;
                            this.val$_selectedLocationMappingFiles = fileArray4;
                            this.val$locationMappingFileComboBoxes = jComboBoxArray2;
                            this.val$analytesAreGenes = bl;
                            this.val$dataType = string;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int i;
                            tmp.dispose();
                            if (inputBeadMappingFiles.length > 1) {
                                for (i = 0; i < csvFiles.length; ++i) {
                                    this.val$_selectedBeadMappingFiles[i] = inputBeadMappingFiles[this.val$beadMappingFileComboBoxes[i].getSelectedIndex()];
                                }
                            }
                            if (this.val$inputLocationMappingFiles.length > 1) {
                                for (i = 0; i < csvFiles.length; ++i) {
                                    this.val$_selectedLocationMappingFiles[i] = this.val$inputLocationMappingFiles[this.val$locationMappingFileComboBoxes[i].getSelectedIndex()];
                                }
                            }
                            new ImportTask(csvFiles, this.val$_selectedLocationMappingFiles, this.val$_selectedBeadMappingFiles, this.val$analytesAreGenes, this.val$dataType).execute();
                        }
                    });
                    cancelButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            tmp.dispose();
                        }
                    });
                    tmp.pack();
                    tmp.setVisible(true);
                } else {
                    new ImportTask(csvFiles, (File[])selectedLocationMappingFiles, (File[])selectedBeadMappingFiles, analytesAreGenes, dataType).execute();
                }
            }
        };
        importCsvDialog.getContentPane().add((Component)UIUtil.buildOKCancelBar(importCsvDialog, okListener), "South");
        importCsvDialog.pack();
        importCsvDialog.setVisible(true);
    }

    private static Project createProject(String[] csvFiles, AbstractSampleInfoFile[] locationAbstractSampleInfoFiles, AbstractSampleInfoFile[] beadAbstractSampleInfoFiles, boolean beadsAlongRows, String dataType) throws IOException, LuminexCsvParser.MissingMappingException {
        LuminexCsvParser[] csvParsers = new LuminexCsvParser[csvFiles.length];
        RowMajorArray2DDataset[] datasets = new RowMajorArray2DDataset[csvParsers.length];
        for (int i = 0; i < csvParsers.length; ++i) {
            RowMajorArray2DDataset dataset;
            try {
                csvParsers[i] = new LuminexCsvParser(csvFiles[i], dataType);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
            AbstractSampleInfoFile locationAbstractSampleInfoFile = locationAbstractSampleInfoFiles != null ? locationAbstractSampleInfoFiles[i] : null;
            AbstractSampleInfoFile beadAbstractSampleInfoFile = beadAbstractSampleInfoFiles != null ? beadAbstractSampleInfoFiles[i] : null;
            csvParsers[i].rename(locationAbstractSampleInfoFile, beadAbstractSampleInfoFile);
            datasets[i] = dataset = csvParsers[i].getDataset();
        }
        Dataset merged = datasets.length == 1 ? datasets[0] : LuminexImporter.merge(datasets, beadsAlongRows, "Luminex");
        MetadataUtil.setColumnMetadataVisibility(merged.getColumnMetadata());
        MetadataUtil.setRowMetadataVisibility(merged.getRowMetadata());
        MetadataUtil.maybeConvertMetadataClass(merged, true);
        return new DefaultProject(merged);
    }

    private static AbstractSampleInfoFile createSampleInfoFile(String file, final boolean isWell) throws IOException {
        String[][] matrix = ((Array2DContentHandler)new ExcelReader(file, new Array2DContentHandler()).getContentHandler()).getData();
        AbstractSampleInfoFile sampleInfo = new AbstractSampleInfoFile(matrix, IOUtil.seqInt(1, matrix[0].length - 1, 1)){

            @Override
            protected Object createKey(String[] array) {
                String key = array[0];
                if (isWell) {
                    key = PlateUtil.checkWellFormat(key);
                }
                return key;
            }
        };
        return sampleInfo;
    }

    private static Dataset merge(RowMajorArray2DDataset[] plates, boolean transpose, String mergedDatasetName) {
        RowMajorArray2DDataset mergedDataset;
        Dataset dataset = plates.length > 1 ? (mergedDataset = DatasetUtil.combineRows(plates, mergedDatasetName)) : plates[0];
        if (transpose) {
            dataset = DatasetUtil.transposeView(dataset);
        }
        return dataset;
    }

    private static class ImportTask
    extends BackgroundTask<ProjectGENEEResultTreeNode> {
        private File[] beadMappingFiles;
        private boolean beadsAlongHeatMapRows;
        private String[] csvFiles;
        private String dataType;
        private File[] locationMappingFiles;

        protected ImportTask(String[] csvFiles, File[] locationMappingFiles, File[] beadMappingFiles, boolean beadsAlongHeatMapRows, String dataType) {
            super("Importing");
            this.beadsAlongHeatMapRows = beadsAlongHeatMapRows;
            this.csvFiles = csvFiles;
            this.locationMappingFiles = locationMappingFiles;
            this.beadMappingFiles = beadMappingFiles;
            this.dataType = dataType;
        }

        @Override
        protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
            AbstractSampleInfoFile[] beadAbstractSampleInfoFile = null;
            AbstractSampleInfoFile[] locationAbstractSampleInfoFile = null;
            if (this.locationMappingFiles != null && this.locationMappingFiles.length != 0) {
                if (this.locationMappingFiles.length != this.csvFiles.length) {
                    throw new IllegalArgumentException(this.locationMappingFiles.length + " location mapping files and " + this.csvFiles.length + " csv files found.");
                }
                locationAbstractSampleInfoFile = new AbstractSampleInfoFile[this.csvFiles.length];
                for (int i = 0; i < this.csvFiles.length; ++i) {
                    locationAbstractSampleInfoFile[i] = LuminexImporter.createSampleInfoFile(this.locationMappingFiles[i].getCanonicalPath(), true);
                }
            }
            if (this.beadMappingFiles != null && this.beadMappingFiles.length != 0) {
                if (this.beadMappingFiles.length != this.csvFiles.length) {
                    throw new IllegalArgumentException(this.beadMappingFiles.length + " bead mapping files and " + this.csvFiles.length + " csv files found.");
                }
                beadAbstractSampleInfoFile = new AbstractSampleInfoFile[this.csvFiles.length];
                HashMap<File, AbstractSampleInfoFile> cachedLookups = new HashMap<File, AbstractSampleInfoFile>();
                for (int i = 0; i < this.csvFiles.length; ++i) {
                    AbstractSampleInfoFile c = (AbstractSampleInfoFile)cachedLookups.get(this.beadMappingFiles[i]);
                    if (c != null) {
                        beadAbstractSampleInfoFile[i] = c;
                        continue;
                    }
                    beadAbstractSampleInfoFile[i] = LuminexImporter.createSampleInfoFile(this.beadMappingFiles[i].getCanonicalPath(), false);
                    cachedLookups.put(this.beadMappingFiles[i], beadAbstractSampleInfoFile[i]);
                }
            }
            Project project = LuminexImporter.createProject(this.csvFiles, locationAbstractSampleInfoFile, beadAbstractSampleInfoFile, this.beadsAlongHeatMapRows, this.dataType);
            History history = new History("Import CSV Files");
            history.add("Files", ToStringUtil.toString(this.csvFiles, ","));
            return new ProjectGENEEResultTreeNode(project, history);
        }

        @Override
        protected void succeeded(ProjectGENEEResultTreeNode n) {
            Application.add(new GENEEFolderNode("Import CSV Files", n.getAuditTrail().last(), n));
        }
    }
}

