/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex.ui.compound.method2;

import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.luminex.PRISMCompoundProcessor;
import org.broadinstitute.genee.luminex.ui.input.CensorPanel;
import org.broadinstitute.genee.luminex.ui.input.InputPanel;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;

public class PRISMCompoundInputGUI {
    private CensorPanel censorPanel;
    private InputPanel inputPanel = new InputPanel();
    private JCheckBox scaleToUntreatedCheckBox = new JCheckBox("Scale to untreated (concentration=0)", true);
    private Project project;

    public PRISMCompoundInputGUI(Project p) {
        this.project = p;
        CellConstraints cc = new CellConstraints();
        this.inputPanel.addBackgroundSubtraction(this.project.getSortedFilteredDataset());
        this.inputPanel.addMetadataInputFields(this.project.getOriginalDataset(), true);
        this.inputPanel.nextRow();
        this.censorPanel = new CensorPanel();
        this.inputPanel.getProcessingOptionsPanel().add((Component)this.censorPanel, cc.xy(1, this.inputPanel.getFormLayout().getRowCount()));
        this.inputPanel.nextRow();
        this.inputPanel.getProcessingOptionsPanel().add((Component)this.scaleToUntreatedCheckBox, cc.xy(1, this.inputPanel.getFormLayout().getRowCount()));
        this.inputPanel.nextRow();
        this.inputPanel.addThresholdTreated();
        this.inputPanel.addCeilingTreated();
        this.inputPanel.nextRow();
        this.inputPanel.addCollapseReplicates(this.project.getSortedFilteredDataset());
        this.inputPanel.nextRow();
    }

    public JPanel getPanel() {
        return this.inputPanel.getProcessingOptionsPanel();
    }

    public void process() {
        boolean thresholdTreated = this.inputPanel.isThresholdValues();
        float thresholdValue = this.inputPanel.isThresholdValues() ? this.inputPanel.getThresholdValue() : 0.0f;
        boolean ceilingTreated = this.inputPanel.isCeilingValues();
        float ceilingValue = ceilingTreated ? this.inputPanel.getCeilingValue() : 0.0f;
        boolean scaleToUntreated = this.scaleToUntreatedCheckBox.isSelected();
        boolean doCensoring = this.censorPanel.isSelected();
        float censorValue = !doCensoring ? 0.0f : this.censorPanel.getValue();
        CollapseMethodOption collapseReplicatesMethod = this.inputPanel.getCollapseReplicatesMethod();
        String plateField = this.inputPanel.getPlateMetadaFieldNameName();
        String[] concOrPuroField = this.inputPanel.getConcentrationOrPuroMetadataFieldName();
        int replicatesSubtractTrimmedMeanS = collapseReplicatesMethod.equals((Object)CollapseMethodOption.TRIMMED_MEAN) ? this.inputPanel.getCollapseReplicatesTrimmedMeanS() : -1;
        int replicatesSubtractTrimmedMeanL = collapseReplicatesMethod.equals((Object)CollapseMethodOption.TRIMMED_MEAN) ? this.inputPanel.getCollapseReplicatesTrimmedMeanL() : -1;
        String[] rowMetadataReplicates = this.inputPanel.getRowMetadataReplicateNames();
        PRISMCompoundProcessor prismProcessor = new PRISMCompoundProcessor();
        prismProcessor.setProject(this.project);
        prismProcessor.setMetadataNames(concOrPuroField, plateField);
        prismProcessor.setCollapseReplicatesMethod(collapseReplicatesMethod, replicatesSubtractTrimmedMeanS, replicatesSubtractTrimmedMeanL, rowMetadataReplicates);
        boolean subtractBackgroud = this.inputPanel.getBackgroundSubtractPanel().isSubtractBackground();
        CollapseMethodOption backgroundSubtractionCollapseMethod = this.inputPanel.getBackgroundSubtractionCollapseMethod();
        int bgSubtractTrimmedMeanS = backgroundSubtractionCollapseMethod.equals((Object)CollapseMethodOption.TRIMMED_MEAN) ? this.inputPanel.getSubtractBackgroundTrimmedMeanS() : -1;
        int bgSubtractTrimmedMeanL = backgroundSubtractionCollapseMethod.equals((Object)CollapseMethodOption.TRIMMED_MEAN) ? this.inputPanel.getSubtractBackgroundTrimmedMeanL() : -1;
        prismProcessor.setBackgroundSubtract(subtractBackgroud, this.inputPanel.getBackgroundSubtractPanel().getCompoundMetadataFieldName(), this.inputPanel.getBackgroundSubtractPanel().getMatchValue(), backgroundSubtractionCollapseMethod, bgSubtractTrimmedMeanS, bgSubtractTrimmedMeanL);
        prismProcessor.setCensor(doCensoring, censorValue);
        prismProcessor.setScaleToUntreated(scaleToUntreated);
        prismProcessor.setThreshold(thresholdTreated, thresholdValue);
        prismProcessor.setCeiling(ceilingTreated, ceilingValue);
        prismProcessor.execute();
    }
}

