/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex.ui.input;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.gui.DatasetAutocomplete;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class BackgroundSubstractionPanel
extends JPanel {
    private JCheckBox backgroundSubtractCheckBox;
    private JComboBox collapseMethodComboBox;
    private JTextField backgroundTextField;
    private static final String sParameter = "The number of smallest elements to trim away (s >= 0)";
    private static final String lParameter = "The number of largest elements to trim away (l >= 0)";
    private JTextField sTextField = new JTextField(6);
    private JTextField lTextField = new JTextField(6);
    private JComboBox compoundFieldNameComboBox;

    public BackgroundSubstractionPanel(Dataset dataset) {
        JPanel topPanel = new JPanel((LayoutManager)new FormLayout(UIUtil.createStringForFormLayout("2dlu", "p", 7), "p"));
        CellConstraints cc = new CellConstraints();
        this.backgroundSubtractCheckBox = new JCheckBox("Subtract", true);
        this.collapseMethodComboBox = UIUtil.createComboBox((Object[])new CollapseMethodOption[]{CollapseMethodOption.MEAN, CollapseMethodOption.MEDIAN, CollapseMethodOption.TRIMMED_MEAN});
        this.collapseMethodComboBox.setSelectedItem((Object)CollapseMethodOption.MEDIAN);
        this.backgroundTextField = new JTextField(12);
        this.backgroundTextField.setText("PCR no DNA");
        this.compoundFieldNameComboBox = UIUtil.createComboBox(MetadataUtil.getNames(dataset.getRowMetadata()).toArray(new String[0]));
        UIUtil.setSelectedItemIgnoreCase(this.compoundFieldNameComboBox, "compound");
        topPanel.add((Component)this.backgroundSubtractCheckBox, cc.xy(1, 1));
        topPanel.add((Component)this.collapseMethodComboBox, cc.xy(3, 1));
        topPanel.add((Component)new JLabel("of"), cc.xy(5, 1));
        topPanel.add((Component)this.compoundFieldNameComboBox, cc.xy(7, 1));
        topPanel.add((Component)new JLabel("="), cc.xy(9, 1));
        topPanel.add((Component)this.backgroundTextField, cc.xy(11, 1));
        topPanel.add((Component)new JLabel("on each plate"), cc.xy(13, 1));
        new DatasetAutocomplete(this.backgroundTextField, dataset, true);
        final JPanel bottomPanel = new JPanel((LayoutManager)new FormLayout("5dlu, pref, 2dlu, pref", "pref, pref"));
        bottomPanel.add((Component)new JLabel(sParameter), cc.xy(2, 1));
        bottomPanel.add((Component)this.sTextField, cc.xy(4, 1));
        bottomPanel.add((Component)new JLabel(lParameter), cc.xy(2, 2));
        bottomPanel.add((Component)this.lTextField, cc.xy(4, 2));
        bottomPanel.setVisible(false);
        this.collapseMethodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                bottomPanel.setVisible(BackgroundSubstractionPanel.this.collapseMethodComboBox.getSelectedItem() == CollapseMethodOption.TRIMMED_MEAN);
            }
        });
        this.backgroundTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                BackgroundSubstractionPanel.this.backgroundSubtractCheckBox.setSelected(true);
            }
        });
        this.setLayout((LayoutManager)new FormLayout("pref", "pref, pref"));
        this.add((Component)topPanel, cc.xy(1, 1));
        this.add((Component)bottomPanel, cc.xy(1, 2));
    }

    protected CollapseMethodOption getMethod() {
        return (CollapseMethodOption)((Object)this.collapseMethodComboBox.getSelectedItem());
    }

    public String getCompoundMetadataFieldName() {
        return (String)this.compoundFieldNameComboBox.getSelectedItem();
    }

    public boolean isSubtractBackground() {
        return this.backgroundSubtractCheckBox.isSelected();
    }

    public String getMatchValue() {
        return this.backgroundTextField.getText().trim();
    }

    public int getTrimmedMeanS() {
        return Integer.parseInt(this.sTextField.getText().trim());
    }

    public int getTrimmedMeanL() {
        return Integer.parseInt(this.lTextField.getText().trim());
    }

    public static enum METHOD {
        MEAN,
        MEDIAN,
        TRIMMED_MEAN;

    }
}

