/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.marker;

import JSci.maths.statistics.BetaDistribution;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.marker.QValue;
import org.broadinstitute.genee.marker.permutation.BalancedCompletePermuter;
import org.broadinstitute.genee.marker.permutation.BalancedRandomPermuter;
import org.broadinstitute.genee.marker.permutation.ContinuousCompletePermuter;
import org.broadinstitute.genee.marker.permutation.ContinuousRandomPermuter;
import org.broadinstitute.genee.marker.permutation.PermutationGenerator;
import org.broadinstitute.genee.marker.permutation.Permuter;
import org.broadinstitute.genee.marker.permutation.UnbalancedCompletePermuter;
import org.broadinstitute.genee.marker.permutation.UnbalancedRandomCovariatePermuter;
import org.broadinstitute.genee.marker.permutation.UnbalancedRandomPermuter;
import org.broadinstitute.genee.math.stat.Fdr;
import org.broadinstitute.genee.math.stat.ZeroFinder;
import org.broadinstitute.genee.math.stat.function.UnivariateFloatFunction;
import org.broadinstitute.genee.math.stat.function.bivariate.AsymptoticTTest;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DefaultClassVector;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.stats.Sorting;

public class MarkerSelection {
    private boolean computeQValues = false;
    private Dataset dataset;
    private DefaultClassVector comparisonClassVector;
    private int numPermutations;
    private int testDirection;
    private boolean balanced;
    private boolean complete;
    private float[] scores;
    private int numRows;
    private DefaultClassVector covariate;
    private int seed;
    private boolean seedUsed = false;
    private float[] fwer;
    private float[] rowSpecificPValues;
    private float[] permutedScores;
    private float[] monotonicPermutedScores;
    private float[] maxT;
    private float[] absoluteScores;
    private int[] descendingAbsIndices;
    private Permuter permuter;
    private float[] lowerBound;
    private float[] upperBound;
    private boolean smoothPValues = true;
    private boolean asymptotic = false;
    private float[] fdr;
    private int[] kArray;
    private int[] descendingIndices;
    private String[] qvalueHeaders;
    private String[] qvalues;
    private boolean savePermutedScores;
    private float[][] savedPermutedScores;
    private BivariateFloatListFunction function;
    private PermutationScore permutationScore;

    public MarkerSelection(Dataset dataset, DefaultClassVector classVector, int permutations, int testDirection, boolean balancedPermutations, boolean complete, BivariateFloatListFunction function, int randomNumberSeed, DefaultClassVector confoundingClassVector, boolean asymptotic, FloatList continuousFloatList) {
        this.dataset = dataset;
        this.asymptotic = asymptotic;
        this.function = function;
        this.comparisonClassVector = classVector;
        this.permutationScore = continuousFloatList != null ? new ContinuousPermutationScore(function, continuousFloatList) : new TwoClassPermutationScore(function);
        this.permutationScore.init(dataset);
        if (classVector != null && classVector.size() != dataset.getColumnCount()) {
            throw new IllegalArgumentException("Number of columns in dataset(" + dataset.getColumnCount() + ") does not match the number of class assignments(" + classVector.size() + ").");
        }
        if (classVector != null && classVector.getClassCount() != 2) {
            throw new IllegalArgumentException("Comparison must have 2 classes. Number of classes is " + classVector.getClassCount() + ".");
        }
        this.numPermutations = permutations;
        this.testDirection = testDirection;
        this.balanced = balancedPermutations;
        this.complete = complete;
        this.seed = randomNumberSeed;
        this.covariate = confoundingClassVector;
        this.numRows = dataset.getRowCount();
        if (testDirection != 0 && testDirection != 1 && testDirection != 2) {
            throw new IllegalArgumentException("Unknown test direction.");
        }
    }

    public void execute() {
        this.computePValues();
    }

    public float[] getAbsoluteScores() {
        return this.absoluteScores;
    }

    public float getBonferroni(int index) {
        return Math.min(this.rowSpecificPValues[index] * (float)this.numRows, 1.0f);
    }

    public int[] getDescendingIndices() {
        return this.descendingIndices;
    }

    public float[] getFdr() {
        return this.fdr;
    }

    public BivariateFloatListFunction getFunction() {
        return this.function;
    }

    public float[] getFwer() {
        return this.fwer;
    }

    public int[] getKArray() {
        return this.kArray;
    }

    public float[] getLowerBound() {
        return this.lowerBound;
    }

    public float[] getMaxT() {
        return this.maxT;
    }

    public int getNumPermutations() {
        return this.numPermutations;
    }

    public String[] getQvalueHeaders() {
        return this.qvalueHeaders;
    }

    public String[] getQValues() {
        return this.qvalues;
    }

    public float[] getRowSpecificPValues() {
        return this.rowSpecificPValues;
    }

    public float[][] getSavedPermutedScores() {
        return this.savedPermutedScores;
    }

    public float[] getScores() {
        return this.scores;
    }

    public int getSeed() {
        return this.seed;
    }

    public int getTestDirection() {
        return this.testDirection;
    }

    public float[] getUpperBound() {
        return this.upperBound;
    }

    public boolean isAsymptotic() {
        return this.asymptotic;
    }

    public boolean isBalanced() {
        return this.balanced;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isComputeQValues() {
        return this.computeQValues;
    }

    public boolean isSavePermutedScores() {
        return this.savePermutedScores;
    }

    public boolean isSeedUsed() {
        return this.seedUsed;
    }

    public boolean isSmoothPValues() {
        return this.smoothPValues;
    }

    public void setComputeQValues(boolean computeQValues) {
        this.computeQValues = computeQValues;
    }

    public void setSavePermutedScores(boolean savePermutedScores) {
        this.savePermutedScores = savePermutedScores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void computePValues() {
        int i;
        int i2;
        this.scores = new float[this.numRows];
        this.lowerBound = new float[this.numRows];
        this.upperBound = new float[this.numRows];
        if (this.comparisonClassVector == null) {
            this.permutationScore.setPermutation(IOUtil.seqInt(this.dataset.getColumnCount()));
        } else {
            int[] classOneIndices = this.comparisonClassVector.getIndices(1);
            int[] assignments = new int[this.dataset.getColumnCount()];
            int length = classOneIndices.length;
            for (i2 = 0; i2 < length; ++i2) {
                assignments[classOneIndices[i2]] = 1;
            }
            this.permutationScore.setPermutation(assignments);
        }
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            this.scores[i3] = this.permutationScore.getScore(i3);
        }
        this.rowSpecificPValues = new float[this.numRows];
        this.descendingIndices = Sorting.index(this.scores, false);
        if (this.comparisonClassVector != null) {
            int[] classZeroIndices = this.comparisonClassVector.getIndices(0);
            int[] classOneIndices = this.comparisonClassVector.getIndices(1);
            if (this.balanced) {
                if (classZeroIndices.length != classOneIndices.length) {
                    throw new IllegalArgumentException("The number of items in each class must be equal for balanced permutations.");
                }
                if (classZeroIndices.length % 2 != 0) {
                    throw new IllegalArgumentException("The number of items in class 0 must be an even number for balanced permutations.");
                }
                if (classOneIndices.length % 2 != 0) {
                    throw new IllegalArgumentException("The number of items in class 1 must be an even number for balanced permutations.");
                }
            }
            if (this.covariate != null) {
                this.seedUsed = true;
                this.permuter = new UnbalancedRandomCovariatePermuter(this.comparisonClassVector, this.covariate, this.seed);
                if (this.complete || this.balanced) {
                    throw new IllegalArgumentException("Covariate permutations not yet implemented for complete or balanced permutations.");
                }
            } else if (this.complete && this.balanced) {
                this.seedUsed = false;
                this.permuter = new BalancedCompletePermuter(classZeroIndices, classOneIndices);
                BigInteger totalPermutations = ((BalancedCompletePermuter)this.permuter).getTotal();
                if (totalPermutations.compareTo(new BigInteger("2147483647")) == 1) {
                    throw new IllegalArgumentException("Number of permutations exceeds maximum of 2147483647.");
                }
                this.numPermutations = totalPermutations.intValue();
            } else if (this.complete && !this.balanced) {
                this.seedUsed = false;
                this.permuter = new UnbalancedCompletePermuter(this.comparisonClassVector.size(), classZeroIndices.length);
                BigInteger totalPermutations = ((UnbalancedCompletePermuter)this.permuter).getTotal();
                if (totalPermutations.compareTo(new BigInteger("2147483647")) == 1) {
                    throw new IllegalArgumentException("Number of permutations exceeds maximum of 2147483647.");
                }
                this.numPermutations = totalPermutations.intValue();
            } else if (!this.complete && this.balanced) {
                this.seedUsed = true;
                this.permuter = new BalancedRandomPermuter(classZeroIndices, classOneIndices, this.seed);
            } else if (!this.complete && !this.balanced) {
                this.seedUsed = true;
                this.permuter = new UnbalancedRandomPermuter(this.comparisonClassVector.size(), this.comparisonClassVector.getIndices(1).length, this.seed);
            } else {
                throw new IllegalArgumentException("Unknown permutation option");
            }
            if (!this.complete && this.numPermutations > 0) {
                if (this.balanced) {
                    BigInteger totalPermutations = new BalancedCompletePermuter(classZeroIndices, classOneIndices).getTotal();
                    if (new BigInteger("" + this.numPermutations).compareTo(totalPermutations) == 1) {
                        this.permuter = new BalancedCompletePermuter(classZeroIndices, classOneIndices);
                        this.complete = true;
                        this.seedUsed = false;
                        this.numPermutations = totalPermutations.intValue();
                    }
                } else if (this.covariate == null) {
                    BigInteger totalPermutations = new UnbalancedCompletePermuter(this.comparisonClassVector.size(), classZeroIndices.length).getTotal();
                    if (new BigInteger("" + this.numPermutations).compareTo(totalPermutations) == 1) {
                        this.permuter = new UnbalancedCompletePermuter(this.comparisonClassVector.size(), classZeroIndices.length);
                        this.complete = true;
                        this.seedUsed = false;
                        this.smoothPValues = false;
                        this.numPermutations = totalPermutations.intValue();
                        System.out.println("Performing all possible permutations of " + this.numPermutations + " choose(" + this.comparisonClassVector.size() + ", " + classZeroIndices.length + ")");
                    }
                }
            }
            if (this.asymptotic) {
                AsymptoticTTest tTest = new AsymptoticTTest();
                DatasetRowView classZeroView = new DatasetRowView(this.dataset, this.comparisonClassVector.getIndices(0));
                DatasetRowView classOneView = new DatasetRowView(this.dataset, classOneIndices);
                for (int i4 = 0; i4 < this.numRows; ++i4) {
                    classZeroView.setIndex(i4);
                    classOneView.setIndex(i4);
                    this.rowSpecificPValues[i4] = tTest.evaluate(classZeroView, classOneView);
                    if (this.testDirection == 2) continue;
                    int n = i4;
                    this.rowSpecificPValues[n] = this.rowSpecificPValues[n] / 2.0f;
                }
            }
        } else {
            if (this.complete || this.numPermutations > 0) {
                // empty if block
            }
            if (this.complete) {
                PermutationGenerator gen = new PermutationGenerator(this.dataset.getColumnCount());
                this.permuter = new ContinuousCompletePermuter(gen);
                this.numPermutations = gen.getTotal().intValue();
            } else {
                this.permuter = new ContinuousRandomPermuter(this.dataset.getColumnCount(), this.seed);
            }
        }
        if (this.complete && this.smoothPValues) {
            System.out.println("Smooth p-values set to false. Smoothing p-values is disabled when performing all possible permutations.");
            this.smoothPValues = false;
        }
        this.permutedScores = new float[this.numRows];
        this.absoluteScores = (float[])this.scores.clone();
        for (i = 0; i < this.numRows; ++i) {
            this.absoluteScores[i] = Math.abs(this.absoluteScores[i]);
        }
        this.descendingAbsIndices = Sorting.index(this.absoluteScores, false);
        this.monotonicPermutedScores = new float[this.numRows];
        this.maxT = new float[this.numRows];
        this.fwer = new float[this.numRows];
        if (!this.asymptotic) {
            this.permute();
        }
        this.monotonicPermutedScores = null;
        this.absoluteScores = null;
        this.permutedScores = null;
        this.kArray = new int[this.numRows];
        if (!this.asymptotic) {
            i = 0;
            while (i < this.numRows) {
                int N = this.numPermutations;
                float k = this.rowSpecificPValues[i];
                this.kArray[i] = (int)k;
                float p = this.smoothPValues ? (k + 1.0f) / (float)(N + 2) : k / (float)N;
                if (this.testDirection == 2) {
                    float oneMinusP = 1.0f - p;
                    if (oneMinusP < p) {
                        p = oneMinusP;
                    }
                    if ((p *= 2.0f) == 0.0f) {
                        float val = this.dataset.getValue(i, 0);
                        boolean flat = true;
                        int cols = this.dataset.getColumnCount();
                        for (int j = 1; j < cols && flat; ++j) {
                            if (this.dataset.getValue(i, j) == val) continue;
                            flat = false;
                        }
                        if (flat) {
                            p = 1.0f;
                        }
                    }
                }
                this.rowSpecificPValues[i] = p;
                if (this.testDirection == 2) {
                    k = 2.0f * Math.min(k, (float)N - k);
                }
                if (this.complete) {
                    this.lowerBound[i] = p;
                    this.upperBound[i] = p;
                } else {
                    float accuracy;
                    float shape1 = k + 1.0f;
                    float shape2 = (float)N - k + 1.0f;
                    final BetaDistribution betaDist = new BetaDistribution((double)shape1, (double)shape2);
                    float plow = (float)betaDist.inverse(0.025);
                    float phigh = (float)betaDist.inverse(0.975);
                    UnivariateFloatFunction function = new UnivariateFloatFunction(){

                        @Override
                        public float evaluate(float x) {
                            float d = (float)Math.min(1.0, 0.95 + betaDist.cumulative((double)x));
                            return (float)(betaDist.probability((double)x) - betaDist.probability(betaDist.inverse((double)d)));
                        }
                    };
                    if (k == 0.0f) {
                        plow = 0.0f;
                        phigh = (float)betaDist.inverse(0.95);
                    } else if (k == (float)N) {
                        plow = (float)betaDist.inverse(0.05);
                        phigh = 1.0f;
                    } else if (k < (float)(N / 2)) {
                        accuracy = Math.min(p / 1000.0f, 1.0E-6f);
                        plow = ZeroFinder.bisection(0.0f, plow, accuracy, function);
                        phigh = (float)betaDist.inverse(0.95 + betaDist.cumulative((double)plow));
                    } else if (k > (float)(N / 2)) {
                        accuracy = Math.min(p / 1000.0f, 1.0E-6f);
                        plow = ZeroFinder.bisection(plow, (float)betaDist.inverse(0.05), accuracy, function);
                        phigh = (float)betaDist.inverse(0.95 + betaDist.cumulative((double)plow));
                    } else {
                        plow = (float)betaDist.inverse(0.025);
                        phigh = (float)betaDist.inverse(0.975);
                    }
                    this.lowerBound[i] = plow;
                    this.upperBound[i] = phigh;
                }
                int n = i;
                this.fwer[n] = this.fwer[n] / (float)N;
                int n2 = i++;
                this.maxT[n2] = this.maxT[n2] / (float)N;
            }
        }
        this.fdr = Fdr.fdr(this.rowSpecificPValues);
        for (i = 1; i < this.numRows; ++i) {
            this.maxT[this.descendingAbsIndices[i]] = Math.max(this.maxT[this.descendingAbsIndices[i]], this.maxT[this.descendingAbsIndices[i - 1]]);
        }
        if (this.computeQValues) {
            PrintWriter tempFileWriter = null;
            String tempFileName = "pvalues.txt";
            try {
                tempFileWriter = new PrintWriter(new FileWriter(tempFileName));
                for (i2 = 0; i2 < this.numRows; ++i2) {
                    tempFileWriter.println(this.rowSpecificPValues[this.descendingIndices[i2]]);
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("An error occurred while saving the output q-value file.");
            }
            finally {
                if (tempFileWriter != null) {
                    tempFileWriter.close();
                }
            }
            QValue.qvalue(new File(tempFileName));
            new File(tempFileName).delete();
        }
        this.qvalues = new String[this.numRows];
        int qvalueHeaderLines = 4;
        this.qvalueHeaders = new String[qvalueHeaderLines];
        BufferedReader br = null;
        File qvalueOutputFile = new File("qvalues.txt");
        if (qvalueOutputFile.exists()) {
            qvalueOutputFile.deleteOnExit();
            try {
                int i5;
                br = new BufferedReader(new FileReader(qvalueOutputFile));
                for (i5 = 0; i5 < qvalueHeaderLines; ++i5) {
                    this.qvalueHeaders[i5] = br.readLine();
                }
                for (i5 = 0; i5 < this.numRows; ++i5) {
                    this.qvalues[i5] = br.readLine();
                }
            }
            catch (IOException ioe) {
                this.qvalueHeaders = new String[0];
                Arrays.fill(this.qvalues, "NaN");
                System.err.println("Unable to compute q values.");
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException x) {}
                }
            }
        } else {
            this.qvalueHeaders = new String[0];
            Arrays.fill(this.qvalues, "NaN");
        }
    }

    private void permute() {
        if (this.savePermutedScores) {
            this.savedPermutedScores = new float[this.numPermutations][this.numRows];
        }
        for (int permutationIndex = 0; permutationIndex < this.numPermutations; ++permutationIndex) {
            int i;
            int[] perm = this.permuter.next();
            this.permutationScore.setPermutation(perm);
            for (i = 0; i < this.numRows; ++i) {
                this.permutedScores[i] = this.permutationScore.getScore(i);
            }
            if (this.savePermutedScores) {
                float[] array = new float[this.permutedScores.length];
                for (float array[i2] : this.permutedScores) {
                }
                this.savedPermutedScores[permutationIndex] = array;
            }
            for (i = 0; i < this.numRows; ++i) {
                float score = this.scores[i];
                if (this.testDirection == 2 || this.testDirection == 0) {
                    if (!(this.permutedScores[i] >= score)) continue;
                    int n = i;
                    this.rowSpecificPValues[n] = this.rowSpecificPValues[n] + 1.0f;
                    continue;
                }
                if (!(this.permutedScores[i] <= score)) continue;
                int n = i;
                this.rowSpecificPValues[n] = this.rowSpecificPValues[n] + 1.0f;
            }
            for (i = 0; i < this.numRows; ++i) {
                this.permutedScores[i] = Math.abs(this.permutedScores[i]);
                this.monotonicPermutedScores[i] = this.permutedScores[i];
            }
            for (i = this.numRows - 2; i >= 0; --i) {
                int indexPlusOne = this.descendingAbsIndices[i + 1];
                int index = this.descendingAbsIndices[i];
                if (!(this.monotonicPermutedScores[indexPlusOne] > this.monotonicPermutedScores[index])) continue;
                this.monotonicPermutedScores[index] = this.monotonicPermutedScores[indexPlusOne];
            }
            for (i = 0; i < this.numRows; ++i) {
                if (!(this.monotonicPermutedScores[i] >= this.absoluteScores[i])) continue;
                int n = i;
                this.maxT[n] = (float)((double)this.maxT[n] + 1.0);
            }
            Arrays.sort(this.permutedScores);
            float[] tmp = new float[this.permutedScores.length];
            int i2 = 0;
            int j = this.permutedScores.length - 1;
            int length = this.permutedScores.length;
            while (i2 < length) {
                tmp[i2] = this.permutedScores[j];
                ++i2;
                --j;
            }
            this.permutedScores = tmp;
            int j2 = 0;
            int count = 0;
            for (int i3 = 0; i3 < this.numRows; ++i3) {
                float score = this.absoluteScores[this.descendingAbsIndices[i3]];
                while (j2 < this.numRows && score < this.permutedScores[j2]) {
                    ++count;
                    ++j2;
                }
                if (count <= 0) continue;
                int n = this.descendingAbsIndices[i3];
                this.fwer[n] = this.fwer[n] + 1.0f;
            }
        }
    }

    private static class TwoClassPermutationScore
    implements PermutationScore {
        private DatasetRowView classZeroView;
        private DatasetRowView classOneView;
        private BivariateFloatListFunction function;

        private TwoClassPermutationScore(BivariateFloatListFunction function) {
            this.function = function;
        }

        @Override
        public float getScore(int index) {
            this.classZeroView.setIndex(index);
            this.classOneView.setIndex(index);
            return this.function.evaluate(this.classZeroView, this.classOneView);
        }

        @Override
        public void init(Dataset dataset) {
            this.classZeroView = new DatasetRowView(dataset);
            this.classOneView = new DatasetRowView(dataset);
        }

        @Override
        public void setPermutation(int[] permutedAssignments) {
            TIntArrayList zeroIndices = new TIntArrayList();
            TIntArrayList oneIndices = new TIntArrayList();
            int length = permutedAssignments.length;
            for (int i = 0; i < length; ++i) {
                if (permutedAssignments[i] == 0) {
                    zeroIndices.add(i);
                    continue;
                }
                oneIndices.add(i);
            }
            int[] permutedClassZeroIndices = zeroIndices.toArray();
            this.classZeroView.setIndices(permutedClassZeroIndices);
            int[] permutedClassOneIndices = oneIndices.toArray();
            this.classOneView.setIndices(permutedClassOneIndices);
        }
    }

    private static class PermutedFloatList
    implements FloatList {
        private FloatList list;
        private int[] indices;

        public PermutedFloatList(FloatList list) {
            this.list = list;
        }

        @Override
        public float getValue(int index) {
            return this.list.getValue(this.indices[index]);
        }

        public void setIndices(int[] indices) {
            this.indices = indices;
        }

        @Override
        public void setValue(int index, float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.indices.length;
        }
    }

    private static interface PermutationScore {
        public float getScore(int var1);

        public void init(Dataset var1);

        public void setPermutation(int[] var1);
    }

    private static class ContinuousPermutationScore
    implements PermutationScore {
        private BivariateFloatListFunction function;
        private PermutedFloatList permutedFloatList;
        private DatasetRowView rowView;

        private ContinuousPermutationScore(BivariateFloatListFunction function, FloatList floatList) {
            this.function = function;
            this.permutedFloatList = new PermutedFloatList(floatList);
        }

        @Override
        public float getScore(int index) {
            this.rowView.setIndex(index);
            return this.function.evaluate(this.permutedFloatList, this.rowView);
        }

        @Override
        public void init(Dataset dataset) {
            this.rowView = new DatasetRowView(dataset);
        }

        @Override
        public void setPermutation(int[] array) {
            this.permutedFloatList.setIndices(array);
        }
    }
}

