/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.marker.permutation;

import java.math.BigInteger;

public class CombinationGenerator {
    private int[] a;
    private int n;
    private int r;
    private BigInteger numLeft;
    private BigInteger total;

    public CombinationGenerator(int n, int r) {
        if (r > n) {
            throw new IllegalArgumentException("r > n");
        }
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        this.n = n;
        this.r = r;
        this.a = new int[r];
        BigInteger nFact = CombinationGenerator.getFactorial(n);
        BigInteger rFact = CombinationGenerator.getFactorial(r);
        BigInteger nminusrFact = CombinationGenerator.getFactorial(n - r);
        this.total = nFact.divide(rFact.multiply(nminusrFact));
        this.reset();
    }

    public int[] getNext() {
        if (this.numLeft.equals(this.total)) {
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.a;
        }
        int i = this.r - 1;
        while (this.a[i] == this.n - this.r + i) {
            --i;
        }
        this.a[i] = this.a[i] + 1;
        for (int j = i + 1; j < this.r; ++j) {
            this.a[j] = this.a[i] + j - i;
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.a;
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    public BigInteger getTotat() {
        return this.total;
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    public void reset() {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = i;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    private static BigInteger getFactorial(int n) {
        BigInteger fact = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            fact = fact.multiply(new BigInteger(Integer.toString(i)));
        }
        return fact;
    }
}

