/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.marker.permutation;

import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.sampling.RandomSampler;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import java.util.Arrays;
import org.broadinstitute.genee.marker.permutation.Permuter;
import org.broadinstitute.genee.matrix.DefaultClassVector;

public class UnbalancedRandomCovariatePermuter
implements Permuter {
    MersenneTwister random;
    long[] values;
    int[] classOneIndices;
    DefaultClassVector covariate;
    int[] choose;
    int size;

    public UnbalancedRandomCovariatePermuter(DefaultClassVector classVector, DefaultClassVector covariate, int seed) {
        this.random = new MersenneTwister(seed);
        this.covariate = covariate;
        this.classOneIndices = classVector.getIndices(1);
        this.choose = new int[covariate.getClassCount()];
        this.size = classVector.size();
        int max = 0;
        int levels = covariate.getClassCount();
        for (int i = 0; i < levels; ++i) {
            int[] covariateIndices = covariate.getIndices(i);
            int numClassOne = 0;
            for (int j = 0; j < this.classOneIndices.length; ++j) {
                if (Arrays.binarySearch(covariateIndices, this.classOneIndices[j]) < 0) continue;
                ++numClassOne;
            }
            this.choose[i] = numClassOne;
            max = Math.max(max, numClassOne);
        }
        this.values = new long[max];
    }

    @Override
    public int[] next() {
        int[] assignments = new int[this.size];
        int levels = this.covariate.getClassCount();
        for (int i = 0; i < levels; ++i) {
            int[] covariateIndices = this.covariate.getIndices(i);
            int n = this.choose[i];
            RandomSampler.sample((long)n, (long)covariateIndices.length, (int)n, (long)0L, (long[])this.values, (int)0, (RandomElement)this.random);
            for (int j = 0; j < n; ++j) {
                int index = covariateIndices[(int)this.values[j]];
                assignments[index] = 1;
            }
        }
        return assignments;
    }
}

