/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math;

import org.broadinstitute.genee.math.stat.function.CoefficientOfVariation;
import org.broadinstitute.genee.math.stat.function.Max;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.MedianAbsoluteDeviation;
import org.broadinstitute.genee.math.stat.function.Min;
import org.broadinstitute.genee.math.stat.function.Percentile;
import org.broadinstitute.genee.math.stat.function.Sum;
import org.broadinstitute.genee.math.stat.function.TrimmedMean;
import org.broadinstitute.genee.math.stat.function.Variance;
import org.broadinstitute.genee.matrix.FloatList;

public class FloatListStatUtils {
    private FloatListStatUtils() {
    }

    public static int countNonMissing(FloatList list) {
        int count = 0;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (Float.isNaN(list.getValue(i))) continue;
            ++count;
        }
        return count;
    }

    public static float cv(FloatList list) {
        return CoefficientOfVariation.cv(list);
    }

    public static float mad(FloatList list) {
        return MedianAbsoluteDeviation.mad(list);
    }

    public static float max(FloatList list) {
        return Max.max(list);
    }

    public static float mean(FloatList list) {
        return Mean.mean(list);
    }

    public static float median(FloatList list) {
        return Percentile.percentileRemoveNans(list, 50.0f);
    }

    public static float min(FloatList list) {
        return Min.min(list);
    }

    public static float percentile(FloatList list, int p) {
        return Percentile.percentileRemoveNans(list, p);
    }

    public static float standardError(FloatList list) {
        return (float)((double)FloatListStatUtils.stdev(list) / Math.sqrt(FloatListStatUtils.countNonMissing(list)));
    }

    public static float stdev(FloatList list) {
        return (float)Math.sqrt(FloatListStatUtils.variance(list, FloatListStatUtils.mean(list)));
    }

    public static float stdev(FloatList list, float mean) {
        return (float)Math.sqrt(FloatListStatUtils.variance(list, mean));
    }

    public static float sum(FloatList list) {
        return Sum.sum(list);
    }

    public static float trimmedMean(FloatList list, int s, int l) {
        return TrimmedMean.trimmedMean(list, s, l);
    }

    public static float variance(FloatList list) {
        return FloatListStatUtils.variance(list, FloatListStatUtils.mean(list));
    }

    public static float variance(FloatList list, float mean) {
        return Variance.variance(list, mean);
    }
}

