/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptToken;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class FunctionInterpreter {
    private Script script;
    private Context cx = Context.enter();
    private Scriptable scope = this.cx.initStandardObjects();
    private Collection<String> variableNames;

    public FunctionInterpreter() {
        float log10 = (float)Math.log(10.0);
        StringBuilder logFunction = new StringBuilder().append("function log(x, base) {");
        logFunction.append("if(!base) base=" + log10 + ";");
        logFunction.append("else base=Math.log(base);");
        logFunction.append("; return x <= 0 ? 0 : (Math.log(x) / base);}");
        this.cx.evaluateString(this.scope, logFunction.toString(), "<cmd>", -1, null);
        this.cx.evaluateString(this.scope, "pow=Math.pow;", "<cmd>", -1, null);
    }

    public void close() {
        Context.exit();
    }

    public float evaluate(float x) {
        this.setValue("x", Float.valueOf(x));
        Object result = this.script.exec(this.cx, this.scope);
        return (float)Context.toNumber((Object)result);
    }

    public Object evaluate() {
        Object result = this.script.exec(this.cx, this.scope);
        return result;
    }

    public Collection<String> getVariableNames() {
        return this.variableNames;
    }

    public Object evaluateString(String source) {
        Object result = this.cx.evaluateString(this.scope, source, "<cmd>", -1, null);
        return result;
    }

    public void setFunction(String function) {
        this.script = this.cx.compileString(function, "<cmd>", -1, null);
        JavaScriptCompressor compressor = null;
        this.variableNames = new LinkedHashSet<String>();
        try {
            compressor = new JavaScriptCompressor(new StringReader(function), new FunctionInterpreterErrorReporter());
            ArrayList tokens = compressor.getTokens();
            for (Object obj : tokens) {
                JavaScriptToken t = (JavaScriptToken)obj;
                System.out.println(t.getValue() + " " + t.getType());
                if (t.getType() != 39) continue;
                this.variableNames.add(t.getValue());
            }
        }
        catch (EvaluatorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSigmoidalDoseResponseFunction() {
        this.setFunction("log(10)/log(2)*(bot + (top - bot) / ( 1 + pow(10, (logec50 - x)*hill_slope)))");
    }

    public void setValue(String variable, Object value) {
        this.scope.put(variable, this.scope, value);
    }

    public Object getValue(String variable) {
        return this.scope.get(variable, this.scope);
    }

    public Function compileFunction(String function) {
        return this.cx.compileFunction(this.scope, function, "<cmd>", -1, null);
    }

    public Object call(Function function, Object[] args) {
        return function.call(this.cx, this.scope, this.scope, args);
    }

    static class FunctionInterpreterErrorReporter
    implements ErrorReporter {
        FunctionInterpreterErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                System.err.println("\n[WARNING] " + message);
            } else {
                System.err.println("\n[WARNING] " + line + ':' + lineOffset + ':' + message);
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                System.err.println("\n[ERROR] " + message);
            } else {
                System.err.println("\n[ERROR] " + line + ':' + lineOffset + ':' + message);
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

