/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.adjust.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Spearman;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.parameters.CheckBoxInputLabel;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.gui.parameters.TextFieldInputParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.math.adjust.Ceiling;
import org.broadinstitute.genee.math.adjust.DivideByFloatListFunction;
import org.broadinstitute.genee.math.adjust.Floor;
import org.broadinstitute.genee.math.adjust.InverseLog2;
import org.broadinstitute.genee.math.adjust.LogScale;
import org.broadinstitute.genee.math.adjust.MeanCenter;
import org.broadinstitute.genee.math.adjust.MedianCenter;
import org.broadinstitute.genee.math.stat.QuantileNorm;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.MedianAbsoluteDeviation;
import org.broadinstitute.genee.math.stat.function.StandardDeviation;
import org.broadinstitute.genee.matrix.ColumnArrayFloatList;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.RowArrayFloatList;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class AdjustDataAlgorithmInput {
    public static final String RANK_NORMALIZATION = "Rank rormalization";
    public static final String QUANTILE_NORMALIZATION = "Quantile normalization";
    public static final String DIVIDE_COLUMN_BY_STDEV = "Divide each column by standard deviation";
    public static final String DIVIDE_COLUMN_BY_MAD = "Divide each column by median absolute deviation";
    public static final String MEDIAN_COLUMN_CENTER = "Subtract median from each column";
    public static final String MEAN_COLUMN_CENTER = "Subtract mean from each column";
    public static final String DIVIDE_ROW_BY_STDEV = "Divide each row by standard deviation";
    public static final String DIVIDE_ROW_BY_MAD = "Divide each row by median absolute deviation";
    public static final String MEDIAN_ROW_CENTER = "Subtract median from each row";
    public static final String MEAN_ROW_CENTER = "Subtract mean from each row";
    public static final String LOG2 = "Log\u2082";
    public static final String INVERSE_LOG2 = "Inverse log\u2082";
    public static final String CEILING = "Ceiling";
    public static final String FLOOR = "Floor";
    private static final String ADJUST_ROW_FUNCTIONS = "adjust rows";
    private static final String ADJUST_COLUMN_FUNCTIONS = "adjust columns";

    public AdjustDataAlgorithmInput(AbstractInputAction abstractInputAction) {
        CheckBoxInputLabel ceilingLabel = new CheckBoxInputLabel(CEILING);
        abstractInputAction.addParameter(ceilingLabel, new TextFieldInputParameter().setDependsOn((JCheckBox)ceilingLabel.getComponent()), false);
        CheckBoxInputLabel floorLabel = new CheckBoxInputLabel(FLOOR);
        abstractInputAction.addParameter(floorLabel, new TextFieldInputParameter().setDependsOn((JCheckBox)floorLabel.getComponent()), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(LOG2), new CheckBoxParameter(LOG2), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(INVERSE_LOG2), new CheckBoxParameter(INVERSE_LOG2), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(MEAN_ROW_CENTER), new CheckBoxParameter(MEAN_ROW_CENTER), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(MEDIAN_ROW_CENTER), new CheckBoxParameter(MEDIAN_ROW_CENTER), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(DIVIDE_ROW_BY_STDEV), new CheckBoxParameter(DIVIDE_ROW_BY_STDEV), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(DIVIDE_ROW_BY_MAD), new CheckBoxParameter(DIVIDE_ROW_BY_MAD), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(MEAN_COLUMN_CENTER), new CheckBoxParameter(MEAN_COLUMN_CENTER), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(MEDIAN_COLUMN_CENTER), new CheckBoxParameter(MEDIAN_COLUMN_CENTER), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(DIVIDE_COLUMN_BY_STDEV), new CheckBoxParameter(DIVIDE_COLUMN_BY_STDEV), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(DIVIDE_COLUMN_BY_MAD), new CheckBoxParameter(DIVIDE_COLUMN_BY_MAD), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(QUANTILE_NORMALIZATION), new CheckBoxParameter(QUANTILE_NORMALIZATION), false);
        abstractInputAction.addSpannedParameter(new HiddenInputLabel(RANK_NORMALIZATION), new CheckBoxParameter(RANK_NORMALIZATION), false);
    }

    public void customizeMap(Project p, Map<String, Object> map) {
        FloatListFunction c;
        ArrayList<FloatListFunction> adjustRowFunctions = new ArrayList<FloatListFunction>();
        ArrayList<FloatListFunction> adjustColumnFunctions = new ArrayList<FloatListFunction>();
        boolean divideColumnByStdev = (Boolean)map.get(DIVIDE_COLUMN_BY_STDEV);
        boolean divideColumnByMad = (Boolean)map.get(DIVIDE_COLUMN_BY_MAD);
        boolean medianColumnCenter = (Boolean)map.get(MEDIAN_COLUMN_CENTER);
        boolean meanColumnCenter = (Boolean)map.get(MEAN_COLUMN_CENTER);
        boolean divideRowByStdev = (Boolean)map.get(DIVIDE_ROW_BY_STDEV);
        boolean divideRowByMad = (Boolean)map.get(DIVIDE_ROW_BY_MAD);
        boolean medianRowCenter = (Boolean)map.get(MEDIAN_ROW_CENTER);
        boolean meanRowCenter = (Boolean)map.get(MEAN_ROW_CENTER);
        boolean log2 = (Boolean)map.get(LOG2);
        boolean inverseLog2 = (Boolean)map.get(INVERSE_LOG2);
        String ceilingString = (String)map.get(CEILING);
        String floorString = (String)map.get(FLOOR);
        if (ceilingString != null && !"".equals(ceilingString)) {
            try {
                float ceiling = ParserHelper.parseFloat(ceilingString);
                c = new Ceiling();
                ((Ceiling)c).setCeiling(ceiling);
                adjustRowFunctions.add(c);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Ceiling is not a number.");
            }
        }
        if (floorString != null && !"".equals(floorString)) {
            try {
                float floor = ParserHelper.parseFloat(floorString);
                c = new Floor();
                ((Floor)c).setFloor(floor);
                adjustRowFunctions.add(c);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Floor is not a number.");
            }
        }
        if (log2) {
            adjustRowFunctions.add(new LogScale());
        } else if (inverseLog2) {
            adjustRowFunctions.add(new InverseLog2());
        }
        if (meanRowCenter) {
            adjustRowFunctions.add(new MeanCenter());
        } else if (medianRowCenter) {
            adjustRowFunctions.add(new MedianCenter());
        }
        if (divideRowByStdev) {
            adjustRowFunctions.add(new DivideByFloatListFunction(new StandardDeviation()));
        }
        if (divideRowByMad) {
            adjustRowFunctions.add(new DivideByFloatListFunction(new MedianAbsoluteDeviation()));
        }
        if (meanColumnCenter) {
            adjustColumnFunctions.add(new MeanCenter());
        } else if (medianColumnCenter) {
            adjustColumnFunctions.add(new MedianCenter());
        }
        if (divideColumnByStdev) {
            adjustColumnFunctions.add(new DivideByFloatListFunction(new StandardDeviation()));
        }
        if (divideColumnByMad) {
            adjustColumnFunctions.add(new DivideByFloatListFunction(new MedianAbsoluteDeviation()));
        }
        map.put(ADJUST_ROW_FUNCTIONS, adjustRowFunctions);
        map.put(ADJUST_COLUMN_FUNCTIONS, adjustColumnFunctions);
    }

    public Dataset execute(Map<String, Object> map) {
        Dataset dataset = (Dataset)map.get("dataset");
        List adjustRowFunctions = (List)map.get(ADJUST_ROW_FUNCTIONS);
        List adjustColumnFunctions = (List)map.get(ADJUST_COLUMN_FUNCTIONS);
        RowArrayFloatList rowList = new RowArrayFloatList(dataset);
        for (FloatListFunction adj : adjustRowFunctions) {
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                rowList.setRowIndex(i);
                adj.evaluate(rowList);
            }
        }
        ColumnArrayFloatList columnList = new ColumnArrayFloatList(rowList.getArray());
        for (FloatListFunction adj : adjustColumnFunctions) {
            int cols = dataset.getColumnCount();
            for (int i = 0; i < cols; ++i) {
                columnList.setColumnIndex(i);
                adj.evaluate(columnList);
            }
        }
        float[][] array = columnList.getArray();
        boolean performColumnRankNormalization = (Boolean)map.get(RANK_NORMALIZATION);
        boolean performQuantileNormalization = (Boolean)map.get(QUANTILE_NORMALIZATION);
        if (performQuantileNormalization) {
            QuantileNorm.qnorm(new RowMajorArray2DDataset("", array));
        }
        if (performColumnRankNormalization) {
            Spearman.columnRankNormalize(array);
        }
        map.remove(ADJUST_ROW_FUNCTIONS);
        map.remove(ADJUST_COLUMN_FUNCTIONS);
        RowMajorArray2DDataset returnValue = DatasetUtil.deepCopy(dataset);
        returnValue.setArray(array);
        return returnValue;
    }
}

