/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat;

import java.util.Arrays;
import java.util.Comparator;
import org.broadinstitute.genee.matrix.Dataset;

public class QuantileNorm {
    private static final DataItemComparator dataItemComparator = new DataItemComparator();

    public static void qnorm(Dataset data) {
        int i;
        int j;
        int rows = data.getRowCount();
        int cols = data.getColumnCount();
        float[] row_mean = new float[rows];
        float[] ranks = new float[rows];
        dataitem[][] dimat = QuantileNorm.get_di_matrix(data);
        for (j = 0; j < cols; ++j) {
            Arrays.sort(dimat[j], dataItemComparator);
        }
        for (i = 0; i < rows; ++i) {
            float sum = 0.0f;
            int numNonMissing = 0;
            for (j = 0; j < cols; ++j) {
                float f = dimat[j][i].data;
                if (Float.isNaN(f)) continue;
                sum += f;
                ++numNonMissing;
            }
            row_mean[i] = sum / (float)numNonMissing;
        }
        for (j = 0; j < cols; ++j) {
            QuantileNorm.get_ranks(ranks, dimat[j], rows);
            for (i = 0; i < rows; ++i) {
                int ind = dimat[j][i].rank;
                if ((double)ranks[i] - Math.floor(ranks[i]) > 0.4) {
                    data.setValue(ind, j, 0.5f * (row_mean[(int)Math.floor(ranks[i]) - 1] + row_mean[(int)Math.floor(ranks[i])]));
                    continue;
                }
                data.setValue(ind, j, row_mean[(int)Math.floor(ranks[i]) - 1]);
            }
        }
    }

    private static dataitem[][] get_di_matrix(Dataset data) {
        int rows = data.getRowCount();
        int cols = data.getColumnCount();
        dataitem[][] dimat = new dataitem[cols][rows];
        for (int j = 0; j < cols; ++j) {
            for (int i = 0; i < rows; ++i) {
                dimat[j][i] = new dataitem();
                dimat[j][i].data = data.getValue(i, j);
                dimat[j][i].rank = i;
            }
        }
        return dimat;
    }

    private static void get_ranks(float[] rank, dataitem[] x, int n) {
        int i = 0;
        while (i < n) {
            int j;
            for (j = i; j < n - 1 && x[j].data == x[j + 1].data; ++j) {
            }
            if (i != j) {
                for (int k = i; k <= j; ++k) {
                    rank[k] = (float)(i + j + 2) / 2.0f;
                }
            } else {
                rank[i] = i + 1;
            }
            i = j + 1;
        }
    }

    private static class DataItemComparator
    implements Comparator<dataitem> {
        private DataItemComparator() {
        }

        @Override
        public int compare(dataitem s1, dataitem s2) {
            if (s1.data < s2.data) {
                return -1;
            }
            if (s1.data > s2.data) {
                return 1;
            }
            return 0;
        }
    }

    private static class dataitem {
        float data;
        int rank;

        private dataitem() {
        }
    }
}

