/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat;

import org.broadinstitute.genee.math.stat.function.UnivariateFloatFunction;

public class ZeroFinder {
    private ZeroFinder() {
    }

    public static float bisection(float a, float b, float epsilon, UnivariateFloatFunction function) {
        float fb;
        float c = 0.0f;
        float fa = function.evaluate(a);
        if (fa * (fb = function.evaluate(b)) > 0.0f) {
            System.out.println("Function has no root on this interval");
            return 0.0f;
        }
        int n = (int)(Math.ceil((Math.log(b - a) - Math.log(epsilon)) / Math.log(2.0)) + 1.0);
        for (int i = 0; i < n; ++i) {
            c = a + 0.5f * (b - a);
            float fc = function.evaluate(c);
            if (fa * fc < 0.0f) {
                b = c;
                fb = fc;
                continue;
            }
            if (fa * fc > 0.0f) {
                a = c;
                fa = fc;
                continue;
            }
            float alpha = c;
            return alpha;
        }
        return c;
    }
}

