/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class Max
implements FloatListFunction {
    @Override
    public float evaluate(FloatList list) {
        return Max.max(list);
    }

    public static float max(FloatList list) {
        float max = -3.4028235E38f;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            float d = list.getValue(i);
            if (Float.isNaN(d)) continue;
            max = d > max ? d : max;
        }
        return max;
    }

    public static float evaluate(float[] values) {
        float max = -3.4028235E38f;
        for (float f : values) {
            if (Float.isNaN(f)) continue;
            max = f > max ? f : max;
        }
        return max;
    }

    public String toString() {
        return "Max";
    }
}

