/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.FloatList;

public class MedianAbsoluteDeviation
implements FloatListFunction {
    private boolean adjust = true;
    private float constant = 1.4826f;
    private float median;

    @Override
    public float evaluate(FloatList list) {
        this.median = FloatListStatUtils.percentile(list, 50);
        int length = list.size();
        float[] temp = new float[length];
        for (int j = 0; j < length; ++j) {
            temp[j] = Math.abs(list.getValue(j) - this.median);
        }
        float r = FloatListStatUtils.percentile(new ArrayFloatList(temp), 50);
        return this.adjust ? r * this.constant : r;
    }

    public float getMedian() {
        return this.median;
    }

    public String toString() {
        return "Median absolute deviation";
    }

    public static float mad(FloatList list) {
        float median = FloatListStatUtils.percentile(list, 50);
        int length = list.size();
        float[] temp = new float[length];
        for (int j = 0; j < length; ++j) {
            temp[j] = Math.abs(list.getValue(j) - median);
        }
        float r = FloatListStatUtils.percentile(new ArrayFloatList(temp), 50);
        return r;
    }
}

