/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import java.util.Arrays;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.matrix.FloatList;

public class TrimmedMean
implements FloatListFunction {
    private int s;
    private int l;

    public TrimmedMean(int s, int l) {
        this.s = s;
        this.l = l;
    }

    @Override
    public float evaluate(FloatList list) {
        return TrimmedMean.trimmedMean(list, this.s, this.l);
    }

    public int getL() {
        return this.l;
    }

    public int getS() {
        return this.s;
    }

    public void setL(int l) {
        this.l = l;
    }

    public void setS(int s) {
        this.s = s;
    }

    public String toString() {
        return "Trimmed mean";
    }

    public static float trimmedMean(FloatList list, int s, int l) {
        int k = list.size();
        if (k == 0) {
            return 0.0f;
        }
        if (s + l >= k) {
            throw new IllegalArgumentException("Not enough data.");
        }
        int length = k;
        float[] ad = new float[list.size()];
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ad[i] = list.getValue(i);
        }
        Arrays.sort(ad);
        float d = Mean.mean(list);
        for (int i1 = 0; i1 < s; ++i1) {
            d += (d - ad[i1]) / (float)(--k);
        }
        for (int j1 = 0; j1 < l; ++j1) {
            d += (d - ad[length - 1 - j1]) / (float)(--k);
        }
        return d;
    }
}

