/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.matrix.FloatList;

public class Variance
implements FloatListFunction {
    @Override
    public float evaluate(FloatList list) {
        return this.evaluate(list, Mean.mean(list));
    }

    public float evaluate(FloatList list, float mean) {
        return Variance.variance(list, mean);
    }

    public static float variance(FloatList list, float mean) {
        float sum = 0.0f;
        float n = 0.0f;
        float _mean = mean;
        int size = list.size();
        for (int j = 0; j < size; ++j) {
            float x = list.getValue(j);
            if (Float.isNaN(x)) continue;
            float diff = x - _mean;
            diff *= diff;
            sum += diff;
            n += 1.0f;
        }
        if ((n -= 1.0f) < 1.0f) {
            n = 1.0f;
        }
        float variance = sum / n;
        return variance;
    }

    public String toString() {
        return "Variance";
    }
}

