/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.apache.commons.math3.stat.inference.TTest;
import org.broadinstitute.genee.math.stat.function.StandardDeviation;
import org.broadinstitute.genee.math.stat.function.bivariate.AbstractTwoClassStatistic;
import org.broadinstitute.genee.matrix.FloatList;

public class AsymptoticTTest
extends AbstractTwoClassStatistic {
    private MyTTest impl = new MyTTest();

    @Override
    public float evaluate(FloatList listOne, FloatList listTwo) {
        float class1Mean = this.useMedian ? this.percentile.evaluate(listOne) : this.mean.evaluate(listOne);
        float class2Mean = this.useMedian ? this.percentile.evaluate(listTwo) : this.mean.evaluate(listTwo);
        float class1Std = this.standardDeviation.evaluate(listOne, class1Mean);
        float class2Std = this.standardDeviation.evaluate(listTwo, class2Mean);
        int listOneSize = 0;
        int size = listOne.size();
        for (int j = 0; j < size; ++j) {
            if (Float.isNaN(listOne.getValue(j))) continue;
            ++listOneSize;
        }
        int listTwoSize = 0;
        int size2 = listTwo.size();
        for (int j = 0; j < size2; ++j) {
            if (Float.isNaN(listTwo.getValue(j))) continue;
            ++listTwoSize;
        }
        if (this.minStandardDeviation) {
            class1Std = StandardDeviation.thresholdStandardDeviation(class1Mean, class1Std, this.minStandardDeviationPercent);
            class2Std = StandardDeviation.thresholdStandardDeviation(class2Mean, class2Std, this.minStandardDeviationPercent);
        }
        return this.impl.execute(class1Mean, class2Mean, class1Std * class1Std, class2Std * class2Std, listOneSize, listTwoSize);
    }

    public String toString() {
        return "Asymptotic T-Test";
    }

    private static class MyTTest
    extends TTest {
        private MyTTest() {
        }

        public float execute(float sample1Mean, float sample1Variance, float sample2Mean, float sample2Variance, int sample1Length, int sample2Length) {
            return (float)this.tTest(sample1Mean, sample2Mean, sample1Variance, sample2Variance, sample1Length, sample2Length);
        }
    }
}

