/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class EuclideanDistance
implements BivariateFloatListFunction {
    @Override
    public float evaluate(FloatList x, FloatList y) {
        float dist = 0.0f;
        int size = x.size();
        for (int i = 0; i < size; ++i) {
            float x_i = x.getValue(i);
            float y_i = y.getValue(i);
            if (Float.isNaN(x_i) || Float.isNaN(y_i)) continue;
            dist += (x_i - y_i) * (x_i - y_i);
        }
        return (float)Math.sqrt(dist);
    }

    public String toString() {
        return "Euclidean Distance";
    }

    public boolean isScaleToOne() {
        return true;
    }
}

