/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class KendallsTau
implements BivariateFloatListFunction {
    @Override
    public float evaluate(FloatList x, FloatList y) {
        int con = 0;
        int dis = 0;
        int exx = 0;
        int exy = 0;
        boolean flag = false;
        int n = x.size();
        for (int i = 0; i < n; ++i) {
            if (Float.isNaN(x.getValue(i)) || Float.isNaN(y.getValue(i))) continue;
            for (int j = 0; j < i; ++j) {
                if (Float.isNaN(x.getValue(j)) || Float.isNaN(y.getValue(j))) continue;
                float x1 = x.getValue(i);
                float x2 = x.getValue(j);
                float y1 = y.getValue(i);
                float y2 = y.getValue(j);
                if (x1 < x2 && y1 < y2) {
                    ++con;
                }
                if (x1 > x2 && y1 > y2) {
                    ++con;
                }
                if (x1 < x2 && y1 > y2) {
                    ++dis;
                }
                if (x1 > x2 && y1 < y2) {
                    ++dis;
                }
                if (x1 == x2 && y1 != y2) {
                    ++exx;
                }
                if (x1 != x2 && y1 == y2) {
                    ++exy;
                }
                flag = true;
            }
        }
        if (!flag) {
            return 0.0f;
        }
        float denomx = con + dis + exx;
        float denomy = con + dis + exy;
        if (denomx == 0.0f) {
            return 1.0f;
        }
        if (denomy == 0.0f) {
            return 1.0f;
        }
        float tau = (float)((double)(con - dis) / Math.sqrt(denomx * denomy));
        return 1.0f - tau;
    }

    public boolean isScaleToOne() {
        return false;
    }

    public String toString() {
        return "Kendall's tau";
    }
}

