/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.matrix.Dataset;

public abstract class AbstractDataset
implements Dataset {
    protected List<Matrix> matrices = new ArrayList<Matrix>();
    protected String name;
    protected Map<Object, Object> properties = new HashMap<Object, Object>();
    protected List<Class<?>> seriesClasses = new ArrayList();
    protected List<String> seriesNames = new ArrayList<String>();

    public int addSeries(String name, Class<?> c) {
        this.seriesNames.add(name);
        this.seriesClasses.add(c);
        this.matrices.add(this.createMatrix());
        return this.seriesNames.size();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Object getObjectValue(int rowIndex, int columnIndex, int seriesIndex) {
        if (seriesIndex == 0) {
            return Float.valueOf(this.getValue(rowIndex, columnIndex));
        }
        Matrix matrix = this.matrices.get(seriesIndex - 1);
        return matrix.get(rowIndex, columnIndex);
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public Class<?> getSeriesClass(int series) {
        if (series == 0) {
            return Float.class;
        }
        return this.seriesClasses.get(series - 1);
    }

    @Override
    public int getSeriesCount() {
        return this.matrices.size() + 1;
    }

    @Override
    public String getSeriesName(int series) {
        if (series == 0) {
            return this.getName();
        }
        return this.seriesNames.get(series - 1);
    }

    @Override
    public float getValue(int rowIndex, int columnIndex, int seriesIndex) {
        if (seriesIndex == 0) {
            return this.getValue(rowIndex, columnIndex);
        }
        Matrix matrix = this.matrices.get(seriesIndex - 1);
        Number number = (Number)matrix.get(rowIndex, columnIndex);
        return number != null ? number.floatValue() : Float.NaN;
    }

    public void removeSeries(int index) {
        if (index > 0) {
            this.seriesNames.remove(index - 1);
            this.seriesClasses.remove(index - 1);
            this.matrices.remove(index - 1);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setObjectValue(int rowIndex, int columnIndex, Object value, int seriesIndex) {
        if (seriesIndex == 0) {
            this.setValue(rowIndex, columnIndex, ((Number)value).floatValue());
        } else {
            Matrix m = this.matrices.get(seriesIndex - 1);
            m.set(rowIndex, columnIndex, value);
        }
    }

    @Override
    public void setProperty(Object key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    protected abstract Matrix createMatrix();

    protected static interface Matrix {
        public Object get(int var1, int var2);

        public void set(int var1, int var2, Object var3);
    }
}

