/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.genee.compound.MolarConcentration;
import org.broadinstitute.genee.matrix.ComparableComparator;
import org.broadinstitute.genee.matrix.Comparators;
import org.broadinstitute.genee.matrix.Vector;

public abstract class AbstractVector
implements Vector {
    private Class<?> columnClass;
    private String name;
    private Comparator<Object> comparator;
    private Map<Object, Object> properties = new HashMap<Object, Object>();
    private static final Map<Class<?>, Comparator> classToComparator = new LinkedHashMap();

    public AbstractVector(String columnName, Class<?> c) {
        this.name = columnName;
        this.columnClass = c;
        for (Class<?> test : classToComparator.keySet()) {
            if (!test.isAssignableFrom(c)) continue;
            this.comparator = classToComparator.get(test);
            break;
        }
        this.properties.put("Discrete Key", true);
    }

    @Override
    public Class<?> getColumnClass() {
        return this.columnClass;
    }

    @Override
    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public void setColumnClass(Class<?> c) {
        this.columnClass = c;
        this.comparator = null;
        for (Class<?> test : classToComparator.keySet()) {
            if (!test.isAssignableFrom(c)) continue;
            this.comparator = classToComparator.get(test);
            break;
        }
        this.properties.put("Discrete Key", true);
    }

    @Override
    public void setComparator(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    @Override
    public void setProperty(Object key, Object value) {
        if (value == null || Boolean.FALSE.equals(value)) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
            if ("Chart Style".equals(key) && !this.properties.containsKey("Chart Color Enabled")) {
                this.properties.put("Chart Color Enabled", true);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    static {
        classToComparator.put(String.class, Comparators.getStringCaseInsensitiveOrder());
        classToComparator.put(Number.class, ComparableComparator.INSTANCE);
        classToComparator.put(Float.TYPE, ComparableComparator.INSTANCE);
        classToComparator.put(Integer.TYPE, ComparableComparator.INSTANCE);
        classToComparator.put(Date.class, ComparableComparator.INSTANCE);
        classToComparator.put(URL.class, ComparableComparator.INSTANCE);
        classToComparator.put(MolarConcentration.class, ComparableComparator.INSTANCE);
    }
}

