/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.matrix.FixedSizeAbstractDataset;

public class BigColumnMajorArray1DDataset
extends FixedSizeAbstractDataset {
    private float[][] arrays;
    private int ncolsPerChunk;

    public BigColumnMajorArray1DDataset(String name, int rows, int columns, float[][] arrays, int ncolsPerChunk) {
        super(name, rows, columns);
        this.arrays = arrays;
        this.ncolsPerChunk = ncolsPerChunk;
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        int arrayIndex = columnIndex / this.ncolsPerChunk;
        float[] array = this.arrays[arrayIndex];
        return array[rowIndex + (columnIndex %= this.ncolsPerChunk) * this.rows];
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, float value) {
        int arrayIndex = columnIndex / this.ncolsPerChunk;
        float[] array = this.arrays[arrayIndex];
        array[rowIndex + (columnIndex %= this.ncolsPerChunk) * this.rows] = value;
    }
}

