/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.FloatList;

public class ColumnArrayFloatList
implements FloatList {
    private int rows;
    private float[][] data;
    private int columnIndex;

    public ColumnArrayFloatList(Dataset dataset) {
        this.rows = dataset.getRowCount();
        int columns = dataset.getColumnCount();
        this.data = new float[this.rows][columns];
        DatasetUtil.copy(dataset, this.data);
    }

    public ColumnArrayFloatList(float[][] data) {
        this.rows = data.length;
        this.data = data;
    }

    @Override
    public float getValue(int index) {
        return this.data[index][this.columnIndex];
    }

    public float[][] getArray() {
        return this.data;
    }

    @Override
    public void setValue(int index, float value) {
        this.data[index][this.columnIndex] = value;
    }

    public void setColumnIndex(int index) {
        this.columnIndex = index;
    }

    @Override
    public int size() {
        return this.rows;
    }
}

