/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.matrix.FixedSizeAbstractDataset;

public class ColumnMajorArray1DDataset
extends FixedSizeAbstractDataset {
    private float[] array;

    public ColumnMajorArray1DDataset(String name, int rows, int columns, float[] array) {
        super(name, rows, columns);
        this.array = array;
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        try {
            return this.array[rowIndex + columnIndex * this.rows];
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new RuntimeException("ArrayIndexOutOfBoundsException at " + rowIndex + ", " + columnIndex);
        }
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, float value) {
        this.array[rowIndex + columnIndex * this.rows] = value;
    }
}

