/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.math.adjust.DivideByFloatListFunction;
import org.broadinstitute.genee.math.adjust.MeanCenter;
import org.broadinstitute.genee.math.stat.function.StandardDeviation;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class DatasetRowColumnNorm {
    public static void allNormalize(RowMajorArray2DDataset dataset) {
        DatasetRowColumnNorm.allNormalize(dataset, 1.0E-4f, 40);
    }

    public static void allNormalize(RowMajorArray2DDataset dataset, float epsilon, int maxTries) {
        float rowChange = Float.MAX_VALUE;
        float colChange = Float.MAX_VALUE;
        for (int iterations = 0; (rowChange > epsilon || colChange > epsilon) && iterations < maxTries; ++iterations) {
            rowChange = DatasetRowColumnNorm.rowNormalize(dataset);
            colChange = DatasetRowColumnNorm.columnNormalize(dataset);
        }
    }

    public static float columnNormalize(RowMajorArray2DDataset dataset) {
        int columns = dataset.getColumnCount();
        float totMean = 0.0f;
        DatasetColumnView view = new DatasetColumnView(dataset);
        MeanCenter meanCenter = new MeanCenter();
        DivideByFloatListFunction divideByStandardDeviation = new DivideByFloatListFunction(new StandardDeviation());
        for (int j = 0; j < columns; ++j) {
            view.setIndex(j);
            float mean = meanCenter.evaluate(view);
            divideByStandardDeviation.evaluate(view);
            totMean += Math.abs(mean);
        }
        return totMean / (float)columns;
    }

    public static float rowNormalize(RowMajorArray2DDataset dataset) {
        int rows = dataset.getRowCount();
        MeanCenter meanCenter = new MeanCenter();
        DivideByFloatListFunction divideByStandardDeviation = new DivideByFloatListFunction(new StandardDeviation());
        DatasetRowView view = new DatasetRowView(dataset);
        float totMean = 0.0f;
        for (int i = 0; i < rows; ++i) {
            view.setIndex(i);
            float mean = meanCenter.evaluate(view);
            divideByStandardDeviation.evaluate(view);
            totMean += Math.abs(mean);
        }
        return totMean / (float)dataset.getRowCount();
    }
}

